<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport"
    content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <title>Login</title>

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
    :root {
      --green-1: #00c896;
      --green-2: #21e3ad;
      --green-3: #0fbf80;
      --green-4: #8fffe0;
      --text-dark: #333;
      --bg-light: #ffffff;
      --green-shadow: rgba(0, 200, 150, 0.55);
    }

    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(to bottom, #ffffff, #f2fffa, #e8fff7);
      color: var(--text-dark);
      overflow-x: hidden;
      position: relative;
    }

    /* Efek Partikel */
    .particles {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      overflow: hidden;
      z-index: -1;
    }

    .particle {
      position: absolute;
      width: 6px;
      height: 6px;
      background: var(--green-2);
      border-radius: 50%;
      animation: float 10s linear infinite;
      opacity: 0.4;
      box-shadow: 0 0 10px var(--green-shadow);
    }

    @keyframes float {
      from { transform: translateY(100vh) scale(0.5); opacity: 0; }
      50% { opacity: 1; }
      to { transform: translateY(-10vh) scale(1); opacity: 0; }
    }

    /* CARD */
    .page-wraper {
      max-width: 600px;
      margin: 0 auto;
      min-height: 100vh;
      background: #ffffffd9;
      border-radius: 20px;
      backdrop-filter: blur(6px);
      box-shadow: 0 0 25px rgba(0, 200, 150, 0.25);
      overflow: hidden;
      position: relative;
    }

    .header {
      display: flex;
      align-items: center;
      padding: 15px;
      position: relative;
      z-index: 2;
    }

    .back-arrow {
      font-size: 24px;
      color: var(--green-1);
      text-decoration: none;
      position: absolute;
      left: 15px;
      font-weight: bold;
    }

    .header-title {
      font-size: 22px;
      font-weight: 700;
      text-align: center;
      flex-grow: 1;
      color: var(--green-1);
      text-shadow: 0 0 12px rgba(0, 200, 150, 0.5);
    }

    .banner-container {
      position: relative;
      overflow: hidden;
    }

    .banner-image {
      width: 100%;
      display: block;
      border-bottom: 2px solid rgba(0, 200, 150, 0.3);
      box-shadow: 0 4px 20px rgba(0, 200, 150, 0.2);
    }

    /* Efek Shine */
    .banner-shine {
      position: absolute;
      top: 0;
      left: -100%;
      width: 60%;
      height: 100%;
      background: linear-gradient(120deg, transparent, rgba(255, 255, 255, 0.5), transparent);
      animation: shineMove 4s infinite;
    }

    @keyframes shineMove {
      0% { left: -100%; }
      50% { left: 120%; }
      100% { left: 120%; }
    }

    .auth-container {
      padding: 25px 25px 40px;
      margin-top: -15px;
      border-top-left-radius: 20px;
      border-top-right-radius: 20px;
      position: relative;
      z-index: 1;
    }

    .tab-navigation {
      display: flex;
      background: rgba(0, 200, 150, 0.10);
      border-radius: 12px;
      padding: 6px;
      margin-bottom: 25px;
      box-shadow: inset 0 0 10px rgba(0, 200, 150, 0.2);
    }

    .tab {
      flex: 1;
      padding: 12px;
      text-align: center;
      font-size: 16px;
      font-weight: 600;
      border-radius: 9px;
      cursor: pointer;
      background: transparent;
      color: var(--text-dark);
      transition: all .3s ease;
      text-decoration: none;
    }

    .tab.active {
      background: linear-gradient(135deg, var(--green-3), var(--green-2));
      color: #fff;
      box-shadow: 0 0 15px var(--green-shadow);
    }

    .input-group {
      margin-bottom: 22px;
      display: flex;
      align-items: center;
      background: rgba(0, 200, 150, 0.08);
      border: 1px solid rgba(0, 200, 150, 0.3);
      border-radius: 14px;
      transition: all .3s;
      overflow: hidden;
    }

    .input-group:focus-within {
      border-color: var(--green-1);
      box-shadow: 0 0 15px rgba(0, 200, 150, 0.5);
      transform: scale(1.02);
    }

    .input-icon {
      width: 50px;
      text-align: center;
      color: var(--green-1);
      font-size: 18px;
      border-right: 1px solid rgba(0, 200, 150, 0.2);
    }

    .input-field {
      flex: 1;
      padding: 15px;
      font-size: 15px;
      background: transparent;
      border: none;
      color: var(--text-dark);
    }

    .input-field::placeholder {
      color: rgba(0, 0, 0, 0.4);
    }

    .input-field:focus {
      outline: none;
    }

    .forgot-link {
      display: block;
      text-align: right;
      font-size: 14px;
      color: var(--green-1);
      text-decoration: none;
      margin-top: 5px;
      font-weight: 500;
    }

    .submit-btn {
      width: 100%;
      padding: 15px;
      background: linear-gradient(135deg, var(--green-1), var(--green-2), var(--green-3));
      color: #ffffff;
      border: none;
      border-radius: 40px;
      font-size: 18px;
      font-weight: 700;
      cursor: pointer;
      margin-top: 20px;
      box-shadow: 0 0 25px var(--green-shadow);
      transition: all 0.3s ease;
    }

    .submit-btn:hover {
      background: linear-gradient(135deg, var(--green-2), var(--green-3), var(--green-1));
      box-shadow: 0 0 35px rgba(0, 200, 150, 0.8);
      transform: scale(1.03);
    }
  </style>
</head>

<body>
  <!-- Partikel -->
  <div class="particles">
    <div class="particle" style="left:10%; animation-delay:0s;"></div>
    <div class="particle" style="left:30%; animation-delay:2s;"></div>
    <div class="particle" style="left:50%; animation-delay:4s;"></div>
    <div class="particle" style="left:70%; animation-delay:1s;"></div>
    <div class="particle" style="left:90%; animation-delay:3s;"></div>
  </div>

  <div class="page-wraper">
    <header class="header">
      <a href="javascript:history.back()" class="back-arrow">&#60;</a>
      <h1 class="header-title">Login</h1>
    </header>

    <div class="banner-container">
      <img src="6129934559768939426.jpg" alt="Banner" class="banner-image">
      <div class="banner-shine"></div>
    </div>

    <div class="auth-container">
      <div class="tab-navigation">
        <button class="tab active">Log In</button>
        <a href="<?php echo e(route('register')); ?>" class="tab">Register</a>
      </div>

      <form action="<?php echo e(url('login')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="input-group">
          <i class="fas fa-mobile-alt input-icon"></i>
          <input type="tel" name="phone" class="input-field" placeholder="Nomor Telepon" required>
        </div>

        <div class="input-group">
          <i class="fas fa-lock input-icon"></i>
          <input type="password" name="password" class="input-field" placeholder="Kata Sandi" required>
        </div>

        <a href="#" class="forgot-link">Lupa kata sandi?</a>

        <button type="submit" class="submit-btn">Masuk Sekarang</button>
      </form>
    </div>
  </div>

  <?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

</html>
<?php /**PATH /home/finewatt/public_html/resources/views/app/auth/login.blade.php ENDPATH**/ ?>