<!DOCTYPE html>
<html lang="bn">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
<title>Home</title>

<style>
:root {
  --primary-maroon:#7F1D1D;
  --deep-maroon:#450A0A;
  --light-maroon:#991B1B;
  --dark-bg:#0B0B0B;
  --card:#141414;
  --text:#F5F5F5;
  --muted:#CFCFCF;
  --glow:rgba(127,29,29,.6);
}

*{margin:0;padding:0;box-sizing:border-box}
body{
  font-family:Poppins,sans-serif;
  background:radial-gradient(circle at top,#1a1a1a,#000);
  color:var(--text);
}

.main-container{
  max-width:600px;
  margin:auto;
  min-height:100vh;
  background:#0e0e0e;
  box-shadow:0 0 40px var(--glow);
  padding-bottom:90px;
}

.header{
  background:linear-gradient(135deg,var(--deep-maroon),var(--primary-maroon));
  padding:15px;
  text-align:center;
  font-weight:700;
}

/* ===== SLIDER ===== */
.slider-wrapper{
  margin:15px;
  border-radius:18px;
  overflow:hidden;
  box-shadow:0 0 25px var(--glow);
}
.slider-container{height:180px;overflow:hidden}
.slider-track{display:flex;width:300%;height:100%;transition:.6s}
.slide{width:100%;flex-shrink:0}
.slide img{width:100%;height:100%;object-fit:cover}
.slider-dots{display:flex;justify-content:center;gap:8px;padding:6px;background:#0e0e0e}
.dot{width:8px;height:8px;border-radius:50%;background:rgba(255,255,255,.3)}
.dot.active{background:#f87171;box-shadow:0 0 8px var(--glow)}

/* ===== PROFILE CARD ===== */
.profile-action-card{
  margin:15px;
  margin-bottom:6px; /* 🔥 DIKETATKAN */
  background:linear-gradient(180deg,#1a1a1a,#0d0d0d);
  border-radius:18px;
  box-shadow:0 0 20px var(--glow);
}

.profile-top{
  display:flex;
  gap:12px;
  padding:15px;
  align-items:center;
}

.profile-avatar{
  width:60px;height:60px;border-radius:50%;
  border:2px solid var(--primary-maroon);
}

.profile-id{font-size:13px;color:var(--muted)}
.profile-label{font-size:12px;color:#fca5a5}
.profile-balance{font-size:20px;font-weight:800;color:#fecaca}

.horizontal-divider{height:1px;background:rgba(127,29,29,.4);margin:0 15px}
.vertical-divider{width:1px;background:rgba(127,29,29,.4)}

.action-card{display:flex;height:120px}

.checkin-area,
.right-btn{
  flex:1;
  display:flex;
  flex-direction:column;
  align-items:center;
  justify-content:center;
  cursor:pointer;
}

.right-area{flex:1;display:flex;flex-direction:column}
.right-btn{flex-direction:row;gap:8px}

/* ===== TABS (DIDEKATKAN) ===== */
.tabs{
  display:flex;
  margin:4px 12px 10px; /* 🔥 RAPAT */
  background:rgba(127,29,29,.2);
  border-radius:12px;
}
.tab{
  flex:1;
  padding:12px;
  background:none;
  border:none;
  color:#fecaca;
  font-weight:700;
}
.tab.active{
  background:linear-gradient(135deg,var(--primary-maroon),var(--light-maroon));
  color:#fff;
}

/* ===== PLAN LIST ===== */
.plan-list{
  display:flex;
  flex-direction:column;
  gap:16px;
  padding:0 12px;
}

/* ===== PLAN CARD ===== */
.plan-card{
  background:linear-gradient(180deg,#1a1a1a,#0f0f0f);
  border-radius:18px;
  overflow:hidden;
  box-shadow:0 0 20px var(--glow);
}

/* IMAGE */
.plan-image{
  position:relative;
  height:160px;
}
.plan-image img{
  width:100%;
  height:100%;
  object-fit:cover;
}

/* BODY */
.plan-body{
  padding:14px;
}

/* TITLE */
.plan-title{
  font-size:16px;
  font-weight:800;
  color:#fecaca;
  text-align:center;
  margin-bottom:12px;
}

/* GRID INFO */
.plan-info-grid{
  display:grid;
  grid-template-columns:repeat(2,1fr);
  gap:10px;
  margin-bottom:14px;
}
.info-box{
  background:#0d0d0d;
  border-radius:12px;
  padding:10px 8px;
  text-align:center;
  border:1px solid rgba(127,29,29,.35);
  box-shadow:inset 0 0 8px rgba(127,29,29,.35);
}
.info-box span{
  font-size:11px;
  color:var(--muted);
}
.info-box strong{
  display:block;
  margin-top:4px;
  font-size:14px;
  font-weight:800;
  color:#fff;
}

/* BUTTON */
.buy-btn{
  width:100%;
  padding:12px;
  border-radius:50px;
  border:none;
  background:linear-gradient(135deg,var(--primary-maroon),var(--light-maroon));
  color:#fff;
  font-weight:800;
  font-size:15px;
  box-shadow:0 0 15px var(--glow);
}
.buy-btn:disabled{
  opacity:.6;
}


</style>
</head>

<body>
<div class="main-container">

<div class="header">BEAUTY CENTER</div>

<!-- SLIDER -->
<div class="slider-wrapper">
  <div class="slider-container">
    <div id="main-slider" class="slider-track">
      <div class="slide"><img src="/images/slide1.jpg"></div>
      <div class="slide"><img src="/images/slide2.jpg"></div>
      <div class="slide"><img src="/images/slide3.jpg"></div>
    </div>
  </div>
  <div id="slider-dots-container" class="slider-dots"></div>
</div>

<!-- PROFILE -->
<div class="profile-action-card">
  <div class="profile-top">
    <img src="logoa.jpg" class="profile-avatar">
    <div>
      <div class="profile-id">ID : <?php echo e(auth()->user()->phone); ?></div>
      <div class="profile-label">Saldo Akun</div>
      <div class="profile-balance"><?php echo e(price(auth()->user()->balance)); ?></div>
    </div>
  </div>

  <div class="horizontal-divider"></div>

  <div class="action-card">
    <div class="checkin-area" onclick="location.href='/checkin'">
      <span>Check-in</span>
    </div>
    <div class="vertical-divider"></div>
    <div class="right-area">
      <div class="right-btn" onclick="openPage('/user/recharge')">Isi Ulang</div>
      <div class="right-btn" onclick="openPage('/withdraw')">Withdraw</div>
    </div>
  </div>
</div>

<script>
function openPage(url){window.location.href=url;}
</script>

</body>
</html>



   <div class="tabs">
  <button class="tab active" onclick="switchTab(event, 'daily-income')">VIP</button>
  <button class="tab" onclick="switchTab(event, 'welfare-plan')">Plus</button>
</div>


    <?php
        use \App\Models\PackageCategory;
        use \App\Models\Package;
        $menu = PackageCategory::get()->toArray();
        $packageOne = Package::where('Status','!=','inactive')->where('tab','vip')->get();
        $packagetwo = Package::where('Status','!=','inactive')->where('tab','fixed')->get();
        $packagethree = Package::where('Status','!=','inactive')->where('tab','event')->get();
    ?>

    <div class="content-wrapper">

<div id="daily-income" class="plan-list">
<?php if($packageOne->count() > 0): ?>
<?php $__currentLoopData = $packageOne; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php
$myVip = \App\Models\Purchase::where('user_id',auth()->id())
    ->where('package_id',$element->id)
    ->where('status','active')
    ->first();
?>

<div class="plan-card">

  <div class="plan-image">
    <img src="<?php echo e(asset($element->photo)); ?>">
  </div>

  <div class="plan-body">
    <div class="plan-title"><?php echo e($element->name); ?></div>

    <div class="plan-info-grid">
      <div class="info-box">
        <span>Harga</span>
        <strong><?php echo e(price($element->price)); ?></strong>
      </div>
      <div class="info-box">
        <span>Pendapatan / Hari</span>
        <strong><?php echo e(price($element->daily_limit)); ?></strong>
      </div>
      <div class="info-box">
        <span>Hari</span>
        <strong><?php echo e($element->validity); ?> Hari</strong>
      </div>
      <div class="info-box">
        <span>Total Pendapatan</span>
        <strong><?php echo e(price($element->daily_limit * $element->validity)); ?></strong>
      </div>
    </div>

    <?php if($myVip): ?>
      <button class="buy-btn" disabled>Aktif</button>
    <?php elseif($element->status == 'coming'): ?>
      <button class="buy-btn" disabled>Coming</button>
    <?php else: ?>
      <button class="buy-btn"
        onclick="openPage('/purchase/confirmation/<?php echo e($element->id); ?>')">
        Beli Sekarang
      </button>
    <?php endif; ?>

  </div>
</div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<p style="text-align:center;padding:20px;">No daily income plans available.</p>
<?php endif; ?>
</div>


        <div id="welfare-plan" class="plan-list" style="display:none;">
<?php $__currentLoopData = array_merge($packagetwo->toArray(), $packagethree->toArray()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

<div class="plan-card">

  <div class="plan-image">
    <img src="<?php echo e(asset($element['photo'])); ?>">
  </div>

  <div class="plan-body">
    <div class="plan-title"><?php echo e($element['name']); ?></div>

    <div class="plan-info-grid">
      <div class="info-box">
        <span>Harga</span>
        <strong><?php echo e(price($element['price'])); ?></strong>
      </div>
      <div class="info-box">
        <span>Pendapatan / Hari</span>
        <strong><?php echo e(price($element['daily_limit'])); ?></strong>
      </div>
      <div class="info-box">
        <span>Siklus</span>
        <strong><?php echo e($element['validity']); ?> Hari</strong>
      </div>
      <div class="info-box">
        <span>Total Pendapatan</span>
        <strong><?php echo e(price($element['daily_limit'] * $element['validity'])); ?></strong>
      </div>
    </div>

    <button class="buy-btn"
      onclick="openPage('/purchase/confirmation/<?php echo e($element['id']); ?>')">
      Beli Sekarang
    </button>

  </div>
</div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

</div>


</div>
<?php echo $__env->make('app.layout.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
function openPage(url){window.location.href=url;}
function goBack(){history.back();}

document.addEventListener('DOMContentLoaded',()=>{
    const slider=document.getElementById('main-slider');
    const dotsContainer=document.getElementById('slider-dots-container');
    const slides=Array.from(slider.children);
    let dots=[];
    slides.forEach((_,i)=>{
        const dot=document.createElement('div');
        dot.classList.add('dot');
        dot.addEventListener('click',()=>goToSlide(i));
        dotsContainer.appendChild(dot);
        dots.push(dot);
    });
    let current=0;
    const goToSlide=(i)=>{
        current=i;
        slider.style.transform=`translateX(-${i*100}%)`;
        dots.forEach((d,idx)=>d.classList.toggle('active',idx===current));
    };
    goToSlide(0);
    if(slides.length>1)setInterval(()=>goToSlide((current+1)%slides.length),3000);
});

function switchTab(evt,id){
    document.querySelectorAll('.plan-list').forEach(p=>p.style.display='none');
    document.querySelectorAll('.tab').forEach(t=>t.classList.remove('active'));
    document.getElementById(id).style.display='flex';
    evt.currentTarget.classList.add('active');
}
</script>
<!-- 🌑 POPUP WHATSAPP - BLACK & MAROON LUXURY THEME -->
<style>
.popup-whatsapp {
  position: fixed;
  inset: 0;
  width: 100%;
  height: 100%;
  background: rgba(5, 5, 5, 0.92);
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 999999;
  animation: fadeInPopup 0.4s ease-in-out;
}

@keyframes fadeInPopup {
  from { opacity: 0; transform: scale(0.96); }
  to { opacity: 1; transform: scale(1); }
}

.popup-box {
  background: linear-gradient(145deg, #120808, #2a0f0f);
  border: 2px solid rgba(127, 29, 29, 0.7);
  border-radius: 22px;
  box-shadow:
    0 0 35px rgba(127, 29, 29, 0.65),
    inset 0 0 15px rgba(255, 255, 255, 0.03);
  text-align: center;
  padding: 32px 26px;
  width: 90%;
  max-width: 330px;
  animation: slideUp 0.5s ease forwards;
}

@keyframes slideUp {
  from { transform: translateY(45px); opacity: 0; }
  to { transform: translateY(0); opacity: 1; }
}

/* 🔥 ICON STYLE */
.popup-box img {
  width: 82px;
  height: 82px;
  filter: drop-shadow(0 0 18px rgba(127, 29, 29, 0.9));
  animation: pulseGlow 2.6s infinite ease-in-out;
  margin-bottom: 18px;
}

@keyframes pulseGlow {
  0%, 100% {
    transform: scale(1);
    filter:
      drop-shadow(0 0 14px rgba(127, 29, 29, 0.6))
      drop-shadow(0 0 28px rgba(69, 10, 10, 0.5));
  }
  50% {
    transform: scale(1.1);
    filter:
      drop-shadow(0 0 32px rgba(127, 29, 29, 1))
      drop-shadow(0 0 45px rgba(69, 10, 10, 0.9));
  }
}

.popup-box h3 {
  color: #FCA5A5;
  font-weight: 800;
  margin-bottom: 10px;
  text-shadow: 0 0 14px rgba(127, 29, 29, 0.9);
}

.popup-box p {
  color: #E5E7EB;
  font-size: 14px;
  margin-bottom: 18px;
  line-height: 1.55;
}

/* 🔴 BUTTON */
.popup-box button {
  background: linear-gradient(135deg, #7F1D1D, #450A0A);
  color: #FEE2E2;
  border: 1px solid rgba(127, 29, 29, 0.8);
  border-radius: 50px;
  padding: 11px 28px;
  font-weight: 700;
  letter-spacing: .4px;
  box-shadow: 0 0 22px rgba(127, 29, 29, 0.75);
  cursor: pointer;
  transition: all 0.35s ease;
}

.popup-box button:hover {
  transform: scale(1.08);
  box-shadow:
    0 0 35px rgba(127, 29, 29, 1),
    0 0 55px rgba(69, 10, 10, 0.9);
}
</style>


<script>
// âœ… FUNGSI ASLI - TIDAK DIUBAH
function showWhatsAppPopup() {
  if (document.querySelector('.popup-whatsapp')) return;

  const popup = document.createElement("div");
  popup.className = "popup-whatsapp";
  popup.innerHTML = `
    <div class="popup-box" id="popupBox">
      <h3>Berinvestasilah Sekarang!</h3>
      <p>
        Gunakan peluang emas dengan.  
        Dapatkan promo eksklusif dan panduan investasi cerdas langsung di grup Channel telegram resmi kami, untuk masuk ke grup wa silakan ambil vip.
      </p>
      <button id="joinNow">Gabung Sekarang</button>
    </div>
  `;
  document.body.appendChild(popup);

  document.getElementById("joinNow").addEventListener("click", () => {
    window.open("https://chat.whatsapp.com/Bh7S23cBc7vGZW8EdDFzei?mode=wwt", "_blank");
    popup.remove();
  });

  popup.addEventListener("click", (e) => {
    if (!document.getElementById("popupBox").contains(e.target)) {
      popup.remove();
    }
  });

  setTimeout(() => popup.remove(), 10000);
}

document.addEventListener("DOMContentLoaded", () => {
  setTimeout(showWhatsAppPopup, 1000);
});
</script>
<?php /**PATH /home/wrkdpgna/public_html/resources/views/app/main/index.blade.php ENDPATH**/ ?>