<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>Gift Code</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<style>
:root {
    --primary-blue: #00eaff;
    --deep-blue: #021526;
    --light-blue: #0077ff;
    --white: #ffffff;
}

/* RESET */
* {margin:0; padding:0; box-sizing:border-box;}
body {
    font-family:'Poppins',sans-serif;
    background: radial-gradient(circle at top, #021526 0%, #010b14 60%, #000 100%);
    color:var(--white);
    overflow-x:hidden;
}

/* ANIMASI LATAR */
.particles {
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    overflow: hidden;
    z-index: -1;
}
.particle {
    position: absolute;
    width: 6px; height: 6px;
    background: var(--primary-blue);
    border-radius: 50%;
    opacity: 0.6;
    animation: float 10s linear infinite;
}
@keyframes float {
    from { transform: translateY(100vh) scale(0.5); opacity: 0; }
    50% { opacity: 1; }
    to { transform: translateY(-10vh) scale(1); opacity: 0; }
}

/* MAIN CONTAINER */
.main-container {
    max-width:600px;
    margin:0 auto;
    min-height:100vh;
    background:rgba(255,255,255,0.05);
    border-radius:20px;
    backdrop-filter:blur(10px);
    box-shadow:0 0 30px rgba(0,234,255,0.2);
    position:relative;
    animation:fadeIn 1s ease-in-out;
    padding-bottom:80px;
}
@keyframes fadeIn {
    from{opacity:0; transform:translateY(10px);}
    to{opacity:1; transform:translateY(0);}
}

/* HEADER */
.header {
    background:linear-gradient(135deg,#002b5b,#004aad);
    color:var(--white);
    padding:15px 20px;
    text-align:center;
    position:relative;
    font-weight:600;
    font-size:1.2rem;
    box-shadow:0 0 20px rgba(0,234,255,0.3);
    border-top-left-radius:20px;
    border-top-right-radius:20px;
}
.back-btn {
    position:absolute;
    left:20px;
    font-size:28px;
    cursor:pointer;
    color:var(--white);
}

/* CARD */
.card {
    background: rgba(255,255,255,0.06);
    border-radius:16px;
    padding:25px;
    box-shadow:0 0 20px rgba(0,234,255,0.2);
    margin:20px;
    backdrop-filter: blur(8px);
    text-align:center;
}

/* REDEEM ICON */
.redeem-icon {
    width:90px;
    height:90px;
    margin:0 auto 20px;
    border-radius:50%;
    background: radial-gradient(circle,#00eaff33,#004aad88);
    display:flex;
    align-items:center;
    justify-content:center;
    box-shadow:0 0 30px rgba(0,234,255,0.4);
    animation:glow 3s infinite alternate;
}
.redeem-icon img {
    width:60%;
    filter: drop-shadow(0 0 10px rgba(0,234,255,0.8));
}
@keyframes glow {
    from { box-shadow:0 0 15px rgba(0,234,255,0.3); transform:scale(1);}
    to { box-shadow:0 0 40px rgba(0,234,255,0.8); transform:scale(1.05);}
}

.card h3 {
    font-size:20px;
    font-weight:600;
    margin-bottom:8px;
    color:var(--primary-blue);
    text-shadow:0 0 8px rgba(0,234,255,0.7);
}
.card p {
    color:#cfd8dc;
    margin-bottom:25px;
}

/* INPUT */
.form-control {
    width:100%;
    height:55px;
    padding:0 20px;
    border-radius:12px;
    border:1px solid rgba(0,234,255,0.3);
    background:rgba(255,255,255,0.08);
    font-size:16px;
    font-weight:500;
    text-align:center;
    letter-spacing:2px;
    color:white;
}
.form-control:focus {
    outline:none;
    box-shadow:0 0 10px rgba(0,234,255,0.4);
    border-color:#00eaff;
}

/* BUTTON */
.submit-btn {
    width:100%;
    padding:14px;
    margin-top:15px;
    background:linear-gradient(135deg,#00eaff,#0077ff);
    border:none;
    border-radius:12px;
    font-weight:600;
    color:white;
    cursor:pointer;
    box-shadow:0 0 20px rgba(0,234,255,0.3);
    transition:all 0.3s ease;
}
.submit-btn:hover {
    box-shadow:0 0 35px rgba(0,234,255,0.7);
    transform:scale(1.03);
}

/* INSTRUCTION */
.instructions-card {
    text-align:left;
}
.instructions-card h4 {
    font-size:16px;
    font-weight:600;
    margin-bottom:15px;
    color:var(--primary-blue);
    text-shadow:0 0 6px rgba(0,234,255,0.5);
}
.instructions-card ul {
    list-style:none;
    color:#cfd8dc;
}
.instructions-card li {
    margin-bottom:10px;
    padding-left:25px;
    position:relative;
}
.instructions-card li::before {
    content:'🎁';
    position:absolute;
    left:0;
    top:0;
    filter:drop-shadow(0 0 6px rgba(0,234,255,0.7));
}
</style>
</head>
<body>
<div class="particles">
  <div class="particle" style="left:10%;animation-delay:0s;"></div>
  <div class="particle" style="left:30%;animation-delay:2s;"></div>
  <div class="particle" style="left:50%;animation-delay:4s;"></div>
  <div class="particle" style="left:70%;animation-delay:1s;"></div>
  <div class="particle" style="left:90%;animation-delay:3s;"></div>
</div>

<div class="main-container">
  <div class="header">
    <span class="back-btn" onclick="history.back()">‹</span>
    Gift Code
  </div>

  <div class="card redeem-card">
      <div class="redeem-icon">
        <img src="https://api.iconify.design/solar:gift-bold-duotone.svg?color=white" alt="gift">
      </div>
      <h3>Redeem Your Gift Code</h3>
      <p>Masukkan kode hadiah Anda di bawah ini untuk klaim bonus menarik!</p>

      <form action="<?php echo e(route('submitBonusCode')); ?>" method="POST">
          <?php echo csrf_field(); ?>
          <input type="text" class="form-control" name="bonus_code" placeholder="Masukkan Kode Hadiah" required>
          <button class="submit-btn" type="submit">Klaim Sekarang</button>
      </form>
  </div>

  <div class="card instructions-card">
      <h4>🎀 Cara Mendapatkan Kode Hadiah:</h4>
      <ul>
          <li>Ikuti channel Telegram resmi kami untuk mendapatkan kode spesial.</li>
          <li>Setiap kode hanya bisa digunakan satu kali.</li>
          <li>Pastikan penulisan kode benar tanpa spasi tambahan.</li>
          <li>Hubungi layanan pelanggan jika mengalami kendala.</li>
      </ul>
  </div>
</div>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="/assets/app/js/jquery.js"></script>
</body>
</html>
<?php /**PATH /home/financew/public_html/resources/views/app/main/promo.blade.php ENDPATH**/ ?>