<!DOCTYPE html>
<html lang="bn">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
<title>Home</title>

<style>
:root {
  --primary-green:#16A34A;
  --deep-green:#064E3B;
  --light-green:#22C55E;
  --dark-bg:#0B0B0B;
  --card:#141414;
  --text:#ECFDF5;
  --muted:#A7F3D0;
  --glow:rgba(34,197,94,.6);
}

*{margin:0;padding:0;box-sizing:border-box}
body{
  font-family:Poppins,sans-serif;
  background:radial-gradient(circle at top,#1a1a1a,#000);
  color:var(--text);
}

.main-container{
  max-width:600px;
  margin:auto;
  min-height:100vh;
  background:#0e0e0e;
  box-shadow:0 0 40px var(--glow);
  padding-bottom:90px;
}

.header{
  background:linear-gradient(135deg,var(--deep-green),var(--primary-green));
  padding:15px;
  text-align:center;
  font-weight:700;
}

/* ===== SLIDER (FIXED) ===== */
.slider-wrapper{
  margin:15px;
  border-radius:18px;
  overflow:hidden;
  box-shadow:0 0 25px var(--glow);
  background:#000;
}

.slider-container{
  height:180px;
  overflow:hidden;
  background:#000;
}

.slider-track{
  display:flex;
  height:100%;
  transition:1s ease-in-out;
  will-change: transform;
}

.slide{
  flex:0 0 100%;
  display:flex;
  align-items:center;
  justify-content:center;
  background:#000;
}

.slide img{
  width:100%;
  height:100%;
  object-fit:contain;
}

/* DOTS */
.slider-dots{
  display:flex;
  justify-content:center;
  gap:8px;
  padding:6px;
  background:#0e0e0e;
}

.dot{
  width:8px;
  height:8px;
  border-radius:50%;
  background:rgba(255,255,255,.3);
}

.dot.active{
  background:var(--light-green);
  box-shadow:0 0 8px var(--glow);
}

/* ===== QUICK MENU GRID ===== */
.quick-menu{
  display:grid;
  grid-template-columns:repeat(4,1fr);
  gap:12px;
  margin:12px;
}

/* ITEM */
.menu-item{
  background:linear-gradient(180deg,#0d0d0d,#0b0b0b);
  border:1px solid rgba(22,163,74,.45);
  border-radius:16px;
  padding:14px 6px;
  text-align:center;
  box-shadow:
    inset 0 0 10px rgba(22,163,74,.35),
    0 0 12px rgba(0,0,0,.6);
  cursor:pointer;
  transition:.35s ease;
}

/* HOVER EFFECT */
.menu-item:hover{
  transform:translateY(-3px) scale(1.05);
  box-shadow:
    0 0 22px rgba(22,163,74,.75),
    inset 0 0 14px rgba(22,163,74,.55);
}

/* ICON */
.menu-icon{
  font-size:26px;
  margin-bottom:6px;
  filter:drop-shadow(0 0 8px rgba(22,163,74,.8));
}

/* TEXT */
.menu-item span{
  display:block;
  font-size:12px;
  font-weight:700;
  color:var(--light-green);
}

/* RESPONSIVE (HP KECIL) */
@media (max-width:420px){
  .menu-icon{font-size:24px}
  .menu-item span{font-size:11px}
}


/* ===== TABS KOTAK ===== */
.tabs{
  display:flex;
  gap:10px;
  margin:6px 12px 14px;
  padding:6px;
  background:rgba(22,163,74,.15);
  border-radius:16px;
}

.tab{
  flex:1;
  padding:14px 0;
  background:linear-gradient(180deg,#0d0d0d,#0b0b0b);
  border:1px solid rgba(22,163,74,.45);
  border-radius:14px;
  color:var(--light-green);
  font-weight:800;
  letter-spacing:.3px;
  cursor:pointer;
  box-shadow:
    inset 0 0 12px rgba(22,163,74,.35),
    0 0 10px rgba(0,0,0,.6);
  transition:.35s ease;
}

/* HOVER */
.tab:hover{
  transform:translateY(-2px);
  box-shadow:
    0 0 22px rgba(22,163,74,.65),
    inset 0 0 14px rgba(22,163,74,.55);
}

/* ACTIVE */
.tab.active{
  background:linear-gradient(135deg,var(--primary-green),var(--light-green));
  color:#fff;
  border:1px solid var(--primary-green);
  box-shadow:
    0 0 30px rgba(22,163,74,.9),
    inset 0 0 18px rgba(255,255,255,.15);
  transform:scale(1.05);
}


/* ===== PLAN LIST ===== */
.plan-list{
  display:flex;
  flex-direction:column;
  gap:16px;
  padding:0 12px;
}

/* ===== PLAN CARD ===== */
.plan-card{
  background:linear-gradient(180deg,#0d0d0d,#0f0f0f);
  border-radius:18px;
  overflow:hidden;
  box-shadow:0 0 20px var(--glow);
}

/* IMAGE */
.plan-image{
  position:relative;
  height:160px;
}
.plan-image img{
  width:100%;
  height:100%;
  object-fit:cover;
}

/* BODY */
.plan-body{
  padding:14px;
}

/* TITLE */
.plan-title{
  font-size:16px;
  font-weight:800;
  color:var(--light-green);
  text-align:center;
  margin-bottom:12px;
}

/* GRID INFO */
.plan-info-grid{
  display:grid;
  grid-template-columns:repeat(2,1fr);
  gap:10px;
  margin-bottom:14px;
}
.info-box{
  background:#0d0d0d;
  border-radius:12px;
  padding:10px 8px;
  text-align:center;
  border:1px solid rgba(22,163,74,.35);
  box-shadow:inset 0 0 8px rgba(22,163,74,.35);
}
.info-box span{
  font-size:11px;
  color:var(--muted);
}
.info-box strong{
  display:block;
  margin-top:4px;
  font-size:14px;
  font-weight:800;
  color:#fff;
}

/* BUTTON */
.buy-btn{
  width:100%;
  padding:12px;
  border-radius:50px;
  border:none;
  background:linear-gradient(135deg,var(--primary-green),var(--light-green));
  color:#fff;
  font-weight:800;
  font-size:15px;
  box-shadow:0 0 15px var(--glow);
}
.buy-btn:disabled{
  opacity:.6;
}


</style>
</head>

<body>
<div class="main-container">

<div class="header">URBIN GRIBB</div>

<!-- SLIDER -->
<div class="slider-wrapper">
  <div class="slider-container">
    <div id="main-slider" class="slider-track">
      <div class="slide"><img src="/Gemini_Generated_Image_679u9u (1).png"></div>
      <div class="slide"><img src="/Gemini_Generated_Imejd5c1ejd5c.png"></div>
      <div class="slide"><img src="/Gemini_Generate_679udo679udo679u (1).png"></div>
    </div>
  </div>
  <div id="slider-dots-container" class="slider-dots"></div>
</div>
<!-- ===== QUICK MENU GRID ===== -->
<div class="quick-menu">
  <div class="menu-item" onclick="openPage('/user/recharge')">
    <div class="menu-icon">💰</div>
    <span>Isi Saldo</span>
  </div>

  <div class="menu-item" onclick="openPage('/withdraw')">
    <div class="menu-icon">🏧</div>
    <span>Penarikan</span>
  </div>

  <div class="menu-item" onclick="window.open('https://chat.whatsapp.com/Bh7S23cBc7vGZW8EdDFzei')">
    <div class="menu-icon">👥</div>
    <span>Grup</span>
  </div>

  <div class="menu-item" onclick="window.location.href='/Tagliasasd.apk'">
    <div class="menu-icon">⬇️</div>
    <span>Download</span>
  </div>
</div>


   <div class="tabs">
  <button class="tab active" onclick="switchTab(event, 'daily-income')">GREEN</button>
  <button class="tab" onclick="switchTab(event, 'welfare-plan')">BLUE</button>
</div>


    <?php
        use \App\Models\PackageCategory;
        use \App\Models\Package;
        $menu = PackageCategory::get()->toArray();
        $packageOne = Package::where('Status','!=','inactive')->where('tab','vip')->get();
        $packagetwo = Package::where('Status','!=','inactive')->where('tab','fixed')->get();
        $packagethree = Package::where('Status','!=','inactive')->where('tab','event')->get();
    ?>

    <div class="content-wrapper">

<div id="daily-income" class="plan-list">
<?php if($packageOne->count() > 0): ?>
<?php $__currentLoopData = $packageOne; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php
$myVip = \App\Models\Purchase::where('user_id',auth()->id())
    ->where('package_id',$element->id)
    ->where('status','active')
    ->first();
?>

<div class="plan-card horizontal">

  <div class="plan-image">
    <img src="<?php echo e(asset($element->photo)); ?>">
  </div>

  <div class="plan-body">
    <div class="plan-title"><?php echo e($element->name); ?></div>

    <div class="plan-info-grid">
      <div class="info-box">
        <span>Harga</span>
        <strong><?php echo e(price($element->price)); ?></strong>
      </div>
      <div class="info-box">
        <span>Pendapatan / Hari</span>
        <strong><?php echo e(price($element->daily_limit)); ?></strong>
      </div>
      <div class="info-box">
        <span>Hari</span>
        <strong><?php echo e($element->validity); ?> Hari</strong>
      </div>
      <div class="info-box">
        <span>Total Pendapatan</span>
        <strong><?php echo e(price($element->daily_limit * $element->validity)); ?></strong>
      </div>
    </div>

    <?php if($myVip): ?>
      <button class="buy-btn" disabled>Aktif</button>
    <?php elseif($element->status == 'coming'): ?>
      <button class="buy-btn" disabled>Coming</button>
    <?php else: ?>
      <button class="buy-btn"
        onclick="openPage('/purchase/confirmation/<?php echo e($element->id); ?>')">
        Beli Sekarang
      </button>
    <?php endif; ?>

  </div>
</div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<p style="text-align:center;padding:20px;">No daily income plans available.</p>
<?php endif; ?>
</div>


        <div id="welfare-plan" class="plan-list" style="display:none;">
<?php $__currentLoopData = array_merge($packagetwo->toArray(), $packagethree->toArray()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

<div class="plan-card horizontal">


  <div class="plan-image">
    <img src="<?php echo e(asset($element['photo'])); ?>">
  </div>

  <div class="plan-body">
    <div class="plan-title"><?php echo e($element['name']); ?></div>

    <div class="plan-info-grid">
      <div class="info-box">
        <span>Harga</span>
        <strong><?php echo e(price($element['price'])); ?></strong>
      </div>
      <div class="info-box">
        <span>Pendapatan / Hari</span>
        <strong><?php echo e(price($element['daily_limit'])); ?></strong>
      </div>
      <div class="info-box">
        <span>Siklus</span>
        <strong><?php echo e($element['validity']); ?> Hari</strong>
      </div>
      <div class="info-box">
        <span>Total Pendapatan</span>
        <strong><?php echo e(price($element['daily_limit'] * $element['validity'])); ?></strong>
      </div>
    </div>

    <button class="buy-btn"
      onclick="openPage('/purchase/confirmation/<?php echo e($element['id']); ?>')">
      Beli Sekarang
    </button>

  </div>
</div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

</div>


</div>
<?php echo $__env->make('app.layout.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
function openPage(url){window.location.href=url;}
function goBack(){history.back();}

document.addEventListener('DOMContentLoaded',()=>{
    const slider=document.getElementById('main-slider');
    const dotsContainer=document.getElementById('slider-dots-container');
    const slides=Array.from(slider.children);
    let dots=[];
    slides.forEach((_,i)=>{
        const dot=document.createElement('div');
        dot.classList.add('dot');
        dot.addEventListener('click',()=>goToSlide(i));
        dotsContainer.appendChild(dot);
        dots.push(dot);
    });
    let current=0;
    const goToSlide=(i)=>{
        current=i;
        slider.style.transform=`translateX(-${i*100}%)`;
        dots.forEach((d,idx)=>d.classList.toggle('active',idx===current));
    };
    goToSlide(0);
    if(slides.length>1)setInterval(()=>goToSlide((current+1)%slides.length),10000);
});

function switchTab(evt,id){
    document.querySelectorAll('.plan-list').forEach(p=>p.style.display='none');
    document.querySelectorAll('.tab').forEach(t=>t.classList.remove('active'));
    document.getElementById(id).style.display='flex';
    evt.currentTarget.classList.add('active');
}
</script>
<!-- 🌑 POPUP WHATSAPP - BLACK & GREEN FUTURISTIC (COMPACT) -->
<style>
.popup-whatsapp{
  position:fixed;
  inset:0;
  background:rgba(0,0,0,.9);
  display:flex;
  justify-content:center;
  align-items:center;
  z-index:999999;
}

.popup-box{
  position:relative;
  background:linear-gradient(145deg,#022C1D,#064E3B);
  border:2px solid rgba(22,163,74,.7);
  border-radius:18px;
  box-shadow:0 0 28px rgba(22,163,74,.65);
  padding:20px 16px 18px;
  width:85%;
  max-width:320px;
  animation:popupUp .45s ease;
  color:#ECFDF5;
  font-family:'Poppins',sans-serif;
  font-size:13px;
}

@keyframes popupUp{
  from{transform:translateY(30px);opacity:0}
  to{transform:translateY(0);opacity:1}
}

/* CLOSE */
.popup-close{
  position:absolute;
  top:8px;
  right:8px;
  width:26px;
  height:26px;
  border-radius:50%;
  background:#064E3B;
  border:1px solid rgba(22,163,74,.7);
  color:#ECFDF5;
  font-size:16px;
  cursor:pointer;
}

/* ICON */
.popup-box img{
  width:60px;
  display:block;
  margin:0 auto 10px;
  filter:drop-shadow(0 0 14px rgba(22,163,74,.9));
}

/* TEXT */
.popup-box h3{
  color:#22C55E;
  font-weight:800;
  text-align:center;
  margin-bottom:8px;
  font-size:16px;
}

.popup-box p{
  color:#A7F3D0;
  font-size:12px;
  line-height:1.4;
  margin:10px 0 12px;
  text-align:center;
}

/* TABLE */
.reward-table{
  width:100%;
  border-collapse: collapse;
  margin-bottom:12px;
  font-size:12px;
}
.reward-table th, .reward-table td{
  border:1px solid rgba(22,163,74,.5);
  padding:5px 4px;
  text-align:center;
}
.reward-table th{
  background:rgba(22,163,74,.2);
  color:#ECFDF5;
  font-weight:700;
}

/* ACTIONS */
.popup-actions{
  display:flex;
  gap:6px;
  margin-bottom:10px;
}
.popup-actions button{
  flex:1;
  border-radius:30px;
  padding:8px 0;
  font-weight:700;
  border:1px solid rgba(22,163,74,.8);
  cursor:pointer;
  font-size:12px;
}

/* BUTTONS */
.btn-group{
  background:linear-gradient(135deg,#064E3B,#022C22);
  color:#ECFDF5;
}
.btn-cs{
  background:linear-gradient(135deg,#16A34A,#064E3B);
  color:#ECFDF5;
  border-color:rgba(22,163,74,.7);
}

/* DOWNLOAD */
.download-app{
  display:block;
  text-align:center;
  margin-top:6px;
  padding:8px;
  border-radius:12px;
  font-weight:700;
  text-decoration:none;
  color:#ECFDF5;
  background:linear-gradient(135deg,#16A34A,#064E3B);
  border:1px solid rgba(22,163,74,.8);
  box-shadow:0 0 12px rgba(22,163,74,.6);
  font-size:12px;
  transition:.35s;
}
.download-app:hover{
  transform:scale(1.05);
  box-shadow:0 0 24px rgba(22,163,74,1);
}
</style>

<script>
function showWhatsAppPopup(){
  if(document.querySelector('.popup-whatsapp')) return;

  const popup=document.createElement("div");
  popup.className="popup-whatsapp";
  popup.innerHTML=`
    <div class="popup-box" id="popupBox">
      <button class="popup-close" id="closePopup">×</button>

      <img src="Gemini_Generated_Image_ovzfygovzfygovzf.png">

      <h3>🎉 BONUS & REWARD</h3>
      <p>
        ✅ Bonus daftar: <b>Rp 10.000</b><br>
        👥 Reward undang team (level & minimal aktif)
      </p>

      <table class="reward-table">
        <thead>
          <tr>
            <th>Level</th>
            <th>Minimal Aktif</th>
            <th>Reward</th>
          </tr>
        </thead>
        <tbody>
          <tr><td>1</td><td>3</td><td>Rp 10.000</td></tr>
          <tr><td>1</td><td>5</td><td>Rp 20.000</td></tr>
          <tr><td>1</td><td>10</td><td>Rp 50.000</td></tr>
          <tr><td>1</td><td>18</td><td>Rp 100.000</td></tr>
          <tr><td>1</td><td>25</td><td>Rp 150.000</td></tr>
          <tr><td>1</td><td>28</td><td>Rp 180.000</td></tr>
          <tr><td>1</td><td>33</td><td>Rp 250.000</td></tr>
        </tbody>
      </table>

      <div class="popup-actions">
        <button class="btn-group" id="joinGroup">Gabung Grup</button>
        <button class="btn-cs" id="callCS">Hubungi CS</button>
      </div>

      <a href="/URBIN_GRada" class="download-app" download>
        ⬇️ Download Aplikasi
      </a>
    </div>
  `;
  document.body.appendChild(popup);

  document.getElementById("joinGroup").onclick=()=>{ 
    window.open("https://chat.whatsapp.com/Bh7S23cBc7vGZW8EdDFzei","_blank"); 
    popup.remove(); 
  };

  document.getElementById("callCS").onclick=()=>{ 
    window.open("https://wa.me/6281234567890","_blank"); 
    popup.remove(); 
  };

  document.getElementById("closePopup").onclick=()=>popup.remove();
}

document.addEventListener("DOMContentLoaded",()=>{ 
  setTimeout(showWhatsAppPopup,500); 
});
</script>
<?php /**PATH /home/pmbnkwnu/public_html/resources/views/app/main/index.blade.php ENDPATH**/ ?>