<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>Gift Code</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

<style>
:root {
  --primary-color: #7F1D1D;       
  --primary-light: #FCA5A5;       
  --primary-gradient: linear-gradient(135deg, #7F1D1D, #991B1B, #450A0A);
  --white: rgba(5,5,5,0.78);     
  --background: #000000;          
  --text-dark: #F8FAFC;           
  --text-light: #E5E7EB;          
}

/* RESET */
* {
  margin:0;
  padding:0;
  box-sizing:border-box;
}

body {
  font-family:'Poppins',sans-serif;
  background:
    linear-gradient(rgba(0,0,0,0.88), rgba(0,0,0,0.95)),
    url("huhu.jpg") center / cover no-repeat fixed;
  color: var(--text-dark);
  overflow-x:hidden;
  min-height:100vh;
}

/* MAIN CONTAINER */
.main-container {
  max-width:600px;
  margin:0 auto;
  min-height:100vh;
  background: transparent;
  border-radius:22px;
  position:relative;
  padding-bottom:80px;
  overflow:hidden;
  animation:fadeIn 0.8s ease-in-out;
}

/* ANIMATION */
@keyframes fadeIn {
  from{opacity:0; transform:translateY(10px);}
  to{opacity:1; transform:translateY(0);}
}

/* HEADER */
.header {
  background: var(--primary-gradient);
  color:#fff;
  padding:16px 20px;
  text-align:center;
  position:relative;
  font-weight:600;
  font-size:1.2rem;
  border-bottom-left-radius:22px;
  border-bottom-right-radius:22px;
  box-shadow:0 12px 40px rgba(127,29,29,0.75);
}
.back-btn {
  position:absolute;
  left:20px;
  font-size:28px;
  cursor:pointer;
  color:#fff;
}

/* CARD */
.card {
  background: var(--white);
  border-radius:18px;
  padding:25px;
  margin:20px;
  box-shadow:0 10px 35px rgba(0,0,0,0.85);
  text-align:center;
  border:1px solid rgba(127,29,29,0.45);
  backdrop-filter: blur(18px);
  -webkit-backdrop-filter: blur(18px);
}

/* REDEEM ICON */
.redeem-icon {
  width:90px;
  height:90px;
  margin:0 auto 20px;
  border-radius:50%;
  background: radial-gradient(circle, rgba(252,165,165,0.35), rgba(127,29,29,0.9));
  display:flex;
  align-items:center;
  justify-content:center;
  box-shadow:0 0 28px rgba(127,29,29,0.85);
  animation:glow 3s infinite alternate;
}
.redeem-icon img {
  width:60%;
  filter: drop-shadow(0 0 14px rgba(252,165,165,0.9));
}
@keyframes glow {
  from { box-shadow:0 0 16px rgba(127,29,29,0.45); transform:scale(1);}
  to { box-shadow:0 0 38px rgba(127,29,29,0.95); transform:scale(1.06);}
}

.card h3 {
  font-size:20px;
  font-weight:600;
  margin-bottom:8px;
  color: var(--primary-light);
}
.card p {
  color: var(--text-light);
  margin-bottom:25px;
}

/* INPUT */
.form-control {
  width:100%;
  height:55px;
  padding:0 20px;
  border-radius:14px;
  border:1px solid rgba(127,29,29,0.45);
  background: rgba(0,0,0,0.9);
  font-size:16px;
  font-weight:500;
  text-align:center;
  color:var(--text-dark);
  transition:0.3s;
}
.form-control:focus {
  outline:none;
  border-color: var(--primary-color);
  box-shadow:0 0 18px rgba(127,29,29,0.75);
}

/* BUTTON */
.submit-btn {
  width:100%;
  padding:15px;
  margin-top:18px;
  background: var(--primary-gradient);
  border:none;
  border-radius:14px;
  font-weight:600;
  color:#fff;
  cursor:pointer;
  box-shadow:0 0 32px rgba(127,29,29,0.75);
  transition:all 0.3s ease;
}
.submit-btn:hover {
  box-shadow:0 0 50px rgba(127,29,29,0.95);
  transform:scale(1.05);
}

/* INSTRUCTION */
.instructions-card {
  text-align:left;
}
.instructions-card h4 {
  font-size:16px;
  font-weight:600;
  margin-bottom:15px;
  color: var(--primary-light);
}
.instructions-card ul {
  list-style:none;
  color: var(--text-light);
}
.instructions-card li {
  margin-bottom:10px;
  padding-left:25px;
  position:relative;
}
.instructions-card li::before {
  content:'🍷';
  position:absolute;
  left:0;
  top:0;
  color: var(--primary-light);
}

/* FADE */
@keyframes fadeUp {
  from {opacity:0; transform:translateY(15px);}
  to {opacity:1; transform:translateY(0);}
}

</style>
</head>

<body>
<div class="main-container">
  <div class="header">
    <span class="back-btn" onclick="history.back()"></span>
    Gift Code
  </div>

  <div class="card redeem-card">
      <div class="redeem-icon">
        <img src="Gemini_Generated_Image_e13o3he13o3he13o.png" alt="gift">
      </div>
      <h3>Redeem Gift Code</h3>
      <p>Masukkan kode hadiah kamu untuk mendapatkan bonus spesial!</p>
      <p>Masukkan kode claim gaji setiap hari MINGGU!</p>

      <form action="<?php echo e(route('submitBonusCode')); ?>" method="POST">
          <?php echo csrf_field(); ?>
          <input type="text" class="form-control" name="bonus_code" placeholder="Masukkan Kode Hadiah" required>
          <button class="submit-btn" type="submit">Klaim Sekarang</button>
      </form>
  </div>

  <div class="card instructions-card">
      <h4>Cara Mendapatkan Kode Hadiah:</h4>
      <ul>
          <li>Ikuti channel wa resmi kami.</li>
          <li>Setiap kode hanya bisa digunakan satu kali.</li>
          <li>Pastikan kode ditulis tanpa spasi berlebih.</li>
          <li>Hubungi CS jika mengalami masalah.</li>
      </ul>
  </div>
</div>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="/assets/app/js/jquery.js"></script>
</body>
</html>
<?php /**PATH /home/nnmuetur/public_html/resources/views/app/main/promo.blade.php ENDPATH**/ ?>