<?php

use App\Http\Controllers\user\OnepayController;
use App\Models\Deposit;
use App\Services\JayaPayment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('number/{type}', [OnepayController::class, 'return_number']);

Route::post('automatic/deposit', function () {
    $data = json_decode(file_get_contents('php://input'), true);

    $response = JayaPayment::callback(config('services.jaya_payment.public_key'), $data);
    if (!$response['status']) {
        return $response['message'];
    }

    $deposit = Deposit::paymentSuccess($id = $data['platOrderNum'], [
        'method_name' => $data['method'],
    ]);

    if (!$deposit) {
        Log::error("FAILED_CALLBACK_DEPOSIT_" . $id);
    }

    return $response['message'];
});
