<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
    <title>Withdrawal Records</title>
    <link rel="shortcut icon" type="image/x-icon" href="/IMG_20250918_172903_494.jpg">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

    <style>
        :root {
            --primary-color: #0047ab;
            --background-color: #f4f6f8;
            --text-color: #333;
            --light-text-color: #6c757d;
            --white-color: #fff;
            --success-color: #28a745;
            --pending-color: #fd7e14;
            --failed-color: #dc3545;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        html, body {
            background-color: var(--background-color);
            overflow-x: hidden;
            width: 100%;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            color: var(--text-color);
            -webkit-font-smoothing: antialiased;
        }

        .main-container { 
            width: 100%;
            max-width: 600px; 
            margin: 0 auto; 
            background-color: var(--background-color); 
            min-height: 100vh; 
            position: relative;
            overflow: hidden;
        }

        /* Header */
        .header { 
            background: var(--white-color); 
            padding: 15px 20px; 
            display: flex; 
            align-items: center; 
            justify-content: center; 
            position: relative;
        }
        
        .header .back-btn { 
            position: absolute; 
            left: 20px; 
            font-size: 28px; 
            color: var(--text-color); 
            cursor: pointer; 
            font-weight: bold; 
        }
        
        .header .header-title { 
            font-size: 1.2rem; 
            font-weight: 600; 
        }

        /* Content Wrapper */
        .content-wrapper { padding: 20px 15px 100px; }

        /* Record List */
        .record-list {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }
        .record-card {
            background: var(--white-color);
            border-radius: 16px;
            padding: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.07);
            display: flex;
            align-items: center;
            gap: 15px;
            border-left: 5px solid var(--failed-color);
        }

        .record-icon-area {
            width: 45px;
            height: 45px;
            flex-shrink: 0;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            background-color: rgba(220, 53, 69, 0.1); 
            color: var(--failed-color);
        }

        .record-details {
            flex-grow: 1;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .record-info .record-reason {
            font-weight: 600;
            font-size: 16px;
            text-transform: capitalize;
            color: var(--text-color);
        }
        .record-info .record-date {
            font-size: 13px;
            color: var(--light-text-color);
        }
        .record-summary { text-align: right; }

        .record-summary .record-amount {
            font-size: 18px;
            font-weight: 700;
            display: block;
            margin-bottom: 5px;
            color: var(--failed-color);
        }

        .record-summary .record-status {
            font-weight: 600;
            padding: 3px 10px;
            border-radius: 20px;
            font-size: 12px;
        }
        .status-approved, .status-successful { background-color: rgba(40, 167, 69, 0.1); color: var(--success-color); }
        .status-pending, .status-processing { background-color: rgba(253, 126, 20, 0.1); color: var(--pending-color); }
        .status-rejected { background-color: rgba(220, 53, 69, 0.1); color: var(--failed-color); }
        
        .no-record {
            text-align: center;
            padding: 40px 20px;
            color: var(--light-text-color);
            background: var(--white-color);
            border-radius: 12px;
        }
    </style>
</head>   
<body>
<div class="main-container">

    <div class="header">
        <span class="back-btn" onclick="history.back()">‹</span>
        <h1 class="header-title">Withdrawal Records</h1>
    </div>

    <div class="content-wrapper">
        @php
            $withdrawals = \App\Models\Withdrawal::where('user_id', auth()->id())->orderByDesc('id')->get();
        @endphp

        @if($withdrawals->count() > 0)
            <div class="record-list">
                @foreach($withdrawals as $record)
                    @php
                        $status = strtolower($record->status);
                        if ($status == 'successful') $status = 'approved';
                        if ($status == 'processing') $status = 'pending';
                        $statusClass = 'status-' . $status;
                    @endphp
                    <div class="record-card type-expense">
                        <div class="record-icon-area icon-expense">
                            <i class="fas fa-arrow-up"></i>
                        </div>
                        <div class="record-details">
                            <div class="record-info">
                                <div class="record-reason">Withdrawal</div>
                                <div class="record-date">{{ $record->created_at->format('d M, Y h:i A') }}</div>
                            </div>
                            <div class="record-summary">
                                <span class="record-amount amount-negative">-{{ price($record->amount) }}</span>
                                <span class="record-status {{ $statusClass }}">{{ ucfirst($status) }}</span>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <div class="no-record">No withdrawal records found.</div>
        @endif
    </div>

</div>

@include('alert-message')
<script src="/assets/app/js/jquery.js"></script>
</body>
</html>