<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
    <title>Help Center</title>
    <link rel="shortcut icon" type="image/x-icon" href="{{setting('logo')}}">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

    <style>
        :root {
            --primary-color: #0047ab;
            --background-color: #f4f6f8;
            --text-color: #333;
            --light-text-color: #6c757d;
            --white-color: #fff;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        html, body {
            background-color: var(--background-color);
            overflow-x: hidden;
            width: 100%;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            color: var(--text-color);
            -webkit-font-smoothing: antialiased;
        }

        a { text-decoration: none; color: inherit; }

        .main-container { 
            width: 100%;
            max-width: 600px; 
            margin: 0 auto; 
            background-color: var(--background-color); 
            min-height: 100vh; 
            position: relative;
            overflow: hidden;
        }

        /* Header */
        .header { 
            background: var(--white-color); 
            padding: 15px 20px; 
            display: flex; 
            align-items: center; 
            justify-content: center; 
            position: relative;
        }
        
        .header .back-btn { 
            position: absolute; 
            left: 20px; 
            font-size: 28px; 
            color: var(--text-color); 
            cursor: pointer; 
            font-weight: bold; 
        }
        
        .header .header-title { 
            font-size: 1.2rem; 
            font-weight: 600; 
        }

        /* Content Wrapper */
        .content-wrapper { padding: 20px 15px 100px; }

        /* Help Card Design */
        .help-list {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }
        .help-card {
            background: var(--white-color);
            border-radius: 16px;
            padding: 20px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.06);
            display: flex;
            align-items: center;
            gap: 20px;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }
        .help-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 25px rgba(0, 71, 171, 0.1);
        }

        .help-card .icon-area {
            width: 50px;
            height: 50px;
            flex-shrink: 0;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: rgba(0, 71, 171, 0.1);
        }
        .help-card .icon-area img {
            width: 28px;
            height: 28px;
        }
        .help-card .text-area {
            flex-grow: 1;
        }
        .help-card .title {
            font-size: 17px;
            font-weight: 600;
            color: var(--text-color);
            margin-bottom: 3px;
        }
        .help-card .description {
            font-size: 14px;
            color: var(--light-text-color);
            line-height: 1.5;
        }

        /* Bottom Navigation */
        .bottom-nav { 
            position: fixed; 
            bottom: 0; 
            left: 50%;
            transform: translateX(-50%);
            width: 100%; 
            max-width: 600px; 
            background: var(--white-color); 
            display: flex; 
            justify-content: space-around; 
            padding: 10px 0; 
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1); 
            align-items: center;
            z-index: 1000;
        }
        .nav-item { 
            display: flex; 
            flex-direction: column; 
            align-items: center; 
            gap: 5px; 
            cursor: pointer; 
            text-decoration: none; 
            color: var(--light-text-color); 
            flex: 1; 
        }
        .nav-icon { width: 24px; height: 24px; }
        .nav-label { font-size: 12px; }
        .nav-item.active .nav-label { color: var(--primary-color); font-weight: 600; }
    </style>
</head>   
<body>
<div class="main-container">

    <div class="header">
        <span class="back-btn" onclick="history.back()">‹</span>
        <h1 class="header-title">Help Center</h1>
    </div>

    <div class="content-wrapper">
        <div class="help-list">
            <a href="{{ setting('telegram_channel') }}" class="help-card">
                <div class="icon-area">
                    <img src="/public/site/img/user/telegram.png" alt="Support Icon">
                </div>
                <div class="text-area">
                    <p class="title">Customers Support</p>
                    <p class="description">Get instant help and support from our team.</p>
                </div>
            </a>
            
            <a href="{{ setting('telegram_group') }}" class="help-card">
                <div class="icon-area">
                     <img src="/public/site/img/user/telegram.png" alt="Telegram Icon">
                </div>
                <div class="text-area">
                    <p class="title">Official Telegram</p>
                    <p class="description">Follow our official channel for the latest news and updates.</p>
                </div>
            </a>
        </div>
    </div>


</div>

<script src="/public/site/layui/layui.js"></script>
</body>
</html>