@php    
    $paymentMethods = \App\Models\PaymentMethod::where('status', 1)->orderBy('id', 'desc')->get();
@endphp

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimal-ui, viewport-fit=cover">
<title>Isi Ulang Saldo</title>
<link rel="shortcut icon" type="image/x-icon" href="{{ setting('logo') }}">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
/* ===============================
   ROOT – TEMA HITAM & HIJAU FULL
================================ */
:root {
  --primary-color: #16A34A;        /* hijau utama */
  --primary-dark: #064E3B;         /* hijau gelap */
  --accent-color: #22C55E;         /* hijau terang */
  --text-dark: #ECFDF5;            /* teks utama */
  --text-light: #A7F3D0;           /* teks sekunder */
  --card-bg: rgba(10, 10, 10, 0.88); /* card hitam transparan */
  --border-color: rgba(22,163,74,0.45);
  --overlay: rgba(0, 0, 0, 0.85);    /* overlay foto */
  --shadow: 0 12px 35px rgba(0,0,0,0.85);
  --hover-shadow: 0 18px 50px rgba(22,163,74,0.65);
}

/* RESET */
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

/* ===============================
   BODY – BACKGROUND FOTO FULL
================================ */
body {
  font-family: 'Poppins', sans-serif;
  color: var(--text-dark);
  width: 100%;
  min-height: 100vh;
  background:
    linear-gradient(var(--overlay), var(--overlay)),
    url("bg.jpg") no-repeat center center fixed;
  background-size: cover;
  overflow-x: hidden;
}

/* ===============================
   MAIN CONTAINER
================================ */
.main-container {
  max-width: 600px;
  margin: auto;
  padding-bottom: 90px;
  background: transparent;
}

/* ===============================
   HEADER
================================ */
.header {
  background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
  padding: 18px 20px;
  text-align: center;
  position: relative;
  border-bottom-left-radius: 22px;
  border-bottom-right-radius: 22px;
  box-shadow: var(--shadow);
  backdrop-filter: blur(12px);
}

.header .back-btn {
  position: absolute;
  left: 20px;
  top: 18px;
  font-size: 26px;
  font-weight: 700;
  cursor: pointer;
  color: var(--text-dark);
  transition: transform 0.3s;
}
.header .back-btn:hover { transform: scale(1.2); }

.header-title {
  font-size: 1.5rem;
  font-weight: 800;
  color: var(--text-dark);
}

/* ===============================
   BALANCE CARD (kotak rapi)
================================ */
.balance-card {
  background: var(--card-bg);
  border: 1px solid var(--border-color);
  border-radius: 22px;
  padding: 25px 20px;
  text-align: center;
  box-shadow: var(--shadow);
  margin-bottom: 25px;
  transition: 0.3s;
}
.balance-card:hover { box-shadow: var(--hover-shadow); }

.balance-label { font-size: 15px; color: var(--text-light); }
.balance-amount {
  font-size: 36px;
  font-weight: 800;
  color: #C0C0C0; /* silver agar angka terlihat */
  margin-top: 5px;
  text-shadow: 0 0 12px var(--accent-color);
}

/* ===============================
   FORM CONTAINER (kotak input rapi)
================================ */
.recharge-form-container {
  background: var(--card-bg);
  border-radius: 20px;
  padding: 22px;
  backdrop-filter: blur(15px);
  box-shadow: var(--shadow);
  border: 1px solid var(--border-color);
  margin-bottom: 20px;
}

.form-label {
  font-weight: 600;
  margin-bottom: 8px;
  display: block;
  color: var(--accent-color);
}

.form-control {
  width: 100%;
  height: 50px;
  border-radius: 14px;
  font-size: 16px;
  font-weight: 700;
  text-align: center;
  background: rgba(5,5,5,0.9);
  border: 2px solid var(--border-color);
  color: #C0C0C0; /* angka input terlihat silver */
  transition: 0.3s;
}

.form-control:focus {
  outline: none;
  border-color: var(--accent-color);
  box-shadow: 0 0 16px var(--accent-color);
}

/* ===============================
   NOMINAL BUTTON (kotak angka)
================================ */
.amount-options {
  display: grid;
  grid-template-columns: repeat(2,1fr);
  gap: 10px;
  margin-top: 14px;
}

.amount-btn {
  padding: 12px 0;
  background: rgba(5,5,5,0.9);
  border: 1px solid var(--border-color);
  border-radius: 14px;
  font-weight: 700;
  font-size: 15px;
  cursor: pointer;
  color: #C0C0C0; /* angka silver */
  transition: 0.25s;
  text-align: center;
}

.amount-btn:hover,
.amount-btn.active {
  background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
  border-color: var(--accent-color);
  box-shadow: var(--hover-shadow);
  transform: translateY(-2px);
}

/* ===============================
   SUBMIT BUTTON
================================ */
.submit-btn {
  width: 100%;
  background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
  border: none;
  border-radius: 14px;
  padding: 15px;
  font-size: 16px;
  font-weight: 800;
  margin-top: 15px;
  cursor: pointer;
  color: #ECFDF5;
  box-shadow: var(--shadow);
}

.submit-btn:hover {
  transform: translateY(-3px);
  box-shadow: var(--hover-shadow);
}

/* ===============================
   INFO SECTION (kotak rapi)
================================ */
.info-section {
  margin-top: 20px;
  background: var(--card-bg);
  border-radius: 18px;
  padding: 18px 15px;
  backdrop-filter: blur(15px);
  box-shadow: var(--shadow);
  position: relative;
}

.info-section::before {
  content: "";
  position: absolute;
  left: 0;
  top: 0;
  width: 5px;
  height: 100%;
  background: var(--accent-color);
  border-radius: 5px 0 0 5px;
}

.info-section h3 { font-size: 18px; margin-bottom: 10px; color: var(--accent-color); }
.info-section ul { list-style: none; }
.info-section ul li {
  margin-bottom: 8px;
  display: flex;
  align-items: center;
  color: var(--text-dark);
}
.info-section ul li i {
  margin-right: 8px;
  color: var(--accent-color);
}
/* CONTAINER TITLE */
.payment-methods-container h5 {
  font-size: 16px;
  font-weight: 700;
  margin-bottom: 10px;
  color: var(--accent-color);
}

/* WRAPPER UNTUK DROPDOWN */
.custom-select-wrapper {
  position: relative;
  display: inline-block;
  width: 100%;
}

/* STYLING SELECT */
.payment-select {
  width: 100%;
  height: 55px;
  padding: 0 20px;
  font-size: 16px;
  font-weight: 700;
  color: #C0C0C0; /* angka/text silver */
  background: rgba(5,5,5,0.9);
  border: 2px solid var(--border-color);
  border-radius: 14px;
  appearance: none; /* hapus style default */
  cursor: pointer;
  transition: all 0.3s ease;
  text-align: left;
}

/* HOVER & FOCUS */
.payment-select:hover,
.payment-select:focus {
  border-color: var(--accent-color);
  box-shadow: 0 0 15px var(--accent-color);
  outline: none;
  background: rgba(5,5,5,0.95);
}

/* ICON PANAH CUSTOM */
.custom-select-wrapper::after {
  content: "▼";
  position: absolute;
  right: 15px;
  top: 50%;
  transform: translateY(-50%);
  color: var(--accent-color);
  font-size: 12px;
  pointer-events: none;
}

/* OPTION */
.payment-select option {
  background: var(--card-bg);
  color: #C0C0C0;
}

/* TRANSISI HALUS */
.payment-select option:hover {
  background: var(--primary-dark);
  color: var(--text-dark);
}

/* WRAPPER TOMBOL SUPAYA TERLIHAT KOTAK */
.form-action-wrapper {
  margin-top: 25px;
  display: flex;
  justify-content: center; /* posisi tengah */
}

/* STYLING TOMBOL */
.recharge-btn {
  width: 100%;
  padding: 16px;
  font-size: 18px;
  font-weight: 700;
  border-radius: 14px;
  border: none;
  cursor: pointer;
  background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
  color: var(--text-dark);
  box-shadow: 0 10px 30px rgba(22,163,74,0.7);
  transition: all 0.3s ease;
  text-align: center;
}

/* EFEK HOVER */
.recharge-btn:hover {
  transform: translateY(-2px) scale(1.03);
  box-shadow: 0 15px 45px rgba(22,163,74,0.95);
  background: linear-gradient(135deg, var(--accent-color), var(--primary-dark));
}

/* EFEK AKTIF SAAT DIKLIK */
.recharge-btn:active {
  transform: scale(0.98);
  box-shadow: 0 8px 25px rgba(22,163,74,0.7);
}

</style>
</head>

<body>
<div class="main-container">
  <div class="header">
    <h1 class="header-title">Isi Ulang Saldo</h1>
  </div>

  <div class="content-wrapper">
    <div class="balance-card">
      <p class="balance-amount">{{ price(auth()->user()->balance) }}</p>
      <span class="balance-label">Saldo Saat Ini</span>
    </div>

    <div class="recharge-form-container">
      <form method="POST" action="{{ url('topup') }}">
        @csrf
        <label class="form-label" for="topupAmount">Masukkan Nominal</label>
        <input id="topupAmount" type="number" min="50000" class="form-control" name="amount" placeholder="Minimal Rp 50.000" required>


        <!-- PILIH METODE PEMBAYARAN -->
        <div class="payment-methods-container">
          <h5>Pilih Metode Pembayaran</h5>
          <select class="payment-select" name="payment_method_id" required>
            <option value="" disabled selected>Pilih Pembayaran</option>
            @foreach($paymentMethods as $method)
              <option value="{{ $method->id }}">{{ $method->name }}</option>
            @endforeach
          </select>
        </div>

        <button type="submit" class="recharge-btn">Konfirmasi Isi Ulang</button>
      </form>
    </div>

    <div class="info-section">
      <h3><i class="fa-solid fa-circle-info"></i> Kebijakan Isi Ulang</h3>
      <ul>
        <li><i class="fa-solid fa-check-circle"></i> Minimal isi ulang adalah <b>Rp 50.000</b>.</li>
        <li><i class="fa-solid fa-lock"></i> Gunakan metode pembayaran resmi di halaman ini.</li>
        <li><i class="fa-solid fa-shield"></i> Dana Anda aman, transaksi terenkripsi.</li>
        <li><i class="fa-solid fa-headset"></i> Jika saldo belum masuk, hubungi layanan pelanggan 24 jam.</li>
      </ul>
    </div>
  </div>
@include('app.layout.menu')
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
<script>
function setAmount(amount){
  $('#topupAmount').val(amount);
  $('.amount-btn').removeClass('active');
  $('.amount-btn[data-amount="'+amount+'"]').addClass('active');
}
</script>
</body>
</html>
