<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Ubuntu:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <title>Fund Transfer</title>
    <style>
        body {
            padding: 0px;
            margin: 0px;
            font-family: 'Roboto', sans-serif;
            color: #333;
        }
        .main-container {
            width: 100%;
            max-width: 600px; /* Added for better viewing on desktop */
            margin: auto;
            min-height: 100vh;
            position: relative;
            background-color: #E0E4E7;
        }
        .bpay-container {
            min-height: 100vh;
            padding: 0px;
        }
        .background-top {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 200px;
            background-color: #006A4E;
        }
        .bpay-timer {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            padding: 15px;
            color: #fff;
            text-align: center;
        }
        .bpay-timer-title {
            font-size: 17px;
            font-weight: bold;
        }
        .bpay-timer-count {
            font-size: 20px;
            font-weight: bold;
            margin: 5px 0;
        }
        .bpay-timer-subtitle {
            font-size: 15px;
        }
        .bpay-body {
            position: absolute;
            top: 110px;
            left: 15px;
            right: 15px;
            bottom: 15px;
            padding: 15px;
            background-color: #fff;
            border-radius: 10px;
            overflow-y: auto; /* Added for scroll on small screens */
        }
        .bpay-body-logo {
            text-align: center;
        }
        .bpay-body-logo img {
            height: 100px; /* Adjusted size */
        }
        .bpay-body-label {
            font-size: 14px;
            color: #555;
            width: 100%;
            text-align: center;
            margin: 15px auto;
            line-height: 1.5;
        }
        .bpay-body-table {
            width: 100%;
            margin: 10px auto;
        }
        .bpay-body-table table {
            width: 100%;
            border-collapse: collapse;
        }
        .bpay-body-table table td {
            padding: 8px 10px;
            vertical-align: middle;
        }
        .bpay-body-table table td.label {
            width: 40%;
            font-size: 14px;
            font-weight: 500;
        }
        .bpay-body-table table td.td-value {
            color: #006A4E;
            font-weight: bold;
            font-size: 16px;
        }
        .bpay-input, .bpay-file-input {
            padding: 8px;
            border: 1px solid #ccc;
            background-color: #f7f7f7;
            width: 100%;
            border-radius: 5px;
            box-sizing: border-box; /* Ensures padding doesn't affect width */
        }
        .bpay-body-button {
            margin-top: 25px;
            text-align: center;
        }
        .bpay-body-button button {
            color: #fff;
            padding: 12px;
            width: 100%;
            max-width: 300px;
            background-color: #006A4E;
            border-radius: 10px;
            border: 0;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
        }
        .bpay-body-logo2 {
            margin-top: 30px;
            text-align: center;
        }
        .bpay-body-logo2 img {
            height: 20px;
        }
        .copy-icon {
            width: 20px;
            height: 20px;
            cursor: pointer;
        }
    </style>
</head>
<body>
<div class="main-container">
    <div class="bpay-container">
        <div class="background-top"></div>
        <div class="bpay-timer">
            <div class="bpay-timer-title">Send Money</div>
            <div class="bpay-timer-count" id="timer"></div>
            <div class="bpay-timer-subtitle">Time Remaining</div>
        </div>
        <div class="bpay-body">
            <div class="bpay-body-logo">
                <img src="{{ asset($methods->photo ?? 'default-logo.png') }}" alt="{{ $methods->name ?? 'Gateway' }}"/>
            </div>
            
            <div class="bpay-body-label">
                Send the requested amount to the number below. Make sure you enter the correct Transaction ID.
            </div>
            
            <div class="bpay-body-table">
                <form action="{{ url('external-deposit') }}" method="post" id="payment_submit">
                    @csrf
                    
                    <input type="hidden" name="methods" value="{{ $methods->name ?? '' }}">
                    <input type="hidden" name="amount" value="{{ $amount ?? 0 }}">
                    
                    <table>
                        <tr>
                            <td class="label">Amount:</td>
                            <td class="td-value" colspan="2">{{ price($amount ?? 0) }}</td>
                        </tr>
                        <tr>
                            <td class="label">Number:</td>
                            <td class="td-value">{{ $methods->address ?? 'N/A' }}</td>
                            <td style="width:30px; text-align:right;">
                                <img src="/public/asset/copy.png" alt="copy" class="copy-icon" onclick="copyNumber('{{ $methods->address ?? '' }}')"/>
                            </td>
                        </tr>
                        
                        <!-- New 'Fake' Number Input Field -->
                        <tr>
                            <td class="label">Sender Number:</td>
                            <td colspan="2">
                                <input type="text" placeholder="Enter your sending number" class="bpay-input"/>
                            </td>
                        </tr>
                        
                        <!-- New 'Fake' Screenshot Upload Field -->
                        <tr>
                            <td class="label">Screenshot:</td>
                            <td colspan="2">
                                <input type="file" class="bpay-file-input"/>
                            </td>
                        </tr>

                        <!-- Functional Transaction ID Field -->
                        <tr>
                            <td class="label">Transaction ID:</td>
                            <td colspan="2">
                                <input type="text" placeholder="Enter Transaction ID" name="trx" class="bpay-input" required/>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
            <div class="bpay-body-button">
                <button onclick="payment_submit_confirm()">Submit</button>
            </div>
            <div class="bpay-body-logo2">
                <img src="/public/asset/check.png" alt="bpay"/>
            </div>
        </div>
    </div>
</div>

@include('alert-message')

<script>
    function payment_submit_confirm() {
        // Simple validation for the required field
        const trxInput = document.querySelector('input[name="trx"]');
        if (trxInput.value.trim() === '') {
            alert('Transaction ID is required.');
            return;
        }
        document.getElementById('payment_submit').submit();
    }

    function copyNumber(text) {
        if (!text) return;
        navigator.clipboard.writeText(text.replaceAll(' ', '')).then(function() {
            // Using your existing 'message' function if it's globally available
            if(typeof message === 'function') {
                message('Copied successfully.');
            } else {
                alert('Copied successfully.');
            }
        }, function(err) {
            console.error('Could not copy text: ', err);
            alert('Failed to copy.');
        });
    }
</script>

<script>
    // Timer script remains unchanged
    (function() {
        const oneSec = 1000;
        const container = document.getElementById('timer');
        if (!container) return;

        let dataHours = sessionStorage.getItem('timer_hours') || '0';
        let dataMinutes = sessionStorage.getItem('timer_minutes') || '59';
        let dataSeconds = sessionStorage.getItem('timer_seconds') || '59';

        let s = parseInt(dataSeconds);
        let m = parseInt(dataMinutes);
        let h = parseInt(dataHours);

        function checkValue(value) {
            return value < 10 ? "0" + value : value;
        }

        function updateDisplay() {
            container.textContent = `${checkValue(h)}:${checkValue(m)}:${checkValue(s)}`;
        }

        const counter = setInterval(() => {
            s--;
            if (s < 0) {
                s = 59;
                m--;
                if (m < 0) {
                    m = 59;
                    h--;
                }
            }

            if (h < 0) {
                h = 0; m = 0; s = 0;
                clearInterval(counter);
                container.textContent = "Time Expired";
            } else {
                sessionStorage.setItem('timer_hours', h);
                sessionStorage.setItem('timer_minutes', m);
                sessionStorage.setItem('timer_seconds', s);
                updateDisplay();
            }
        }, oneSec);

        updateDisplay();
    })();
</script>
</body>
</html>