<!doctype html> 
<html lang="en">
<head>
    <meta data-n-head="ssr" charset="utf-8">
    <meta data-n-head="ssr" name="viewport" content="width=device-width, initial-scale=1">
    <meta data-n-head="ssr" data-hid="description" name="description" content="{{env('APP_NAME')}} APP">
    <title>{{env('APP_NAME')}}</title>
    <link rel="stylesheet" href="{{asset('public/setting.css')}}">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

<style>
/* === MODERN THEME PROFILE PAGE === */
body {
    background: linear-gradient(135deg, #001a3d, #002f5a);
    color: #fff;
    font-family: 'Poppins', sans-serif;
    margin: 0;
    padding-bottom: 80px;
}
.settings-space-header {
    background: linear-gradient(135deg, #002b5b, #004aad);
    text-align: center;
    padding: 40px 20px 30px;
    border-bottom: 1px solid rgba(255,255,255,0.15);
    box-shadow: 0 4px 20px rgba(0,0,0,0.4);
    border-radius: 0 0 20px 20px;
}
.settings-space-header img {
    width: 100px;
    height: 100px;
    border-radius: 16px;
    box-shadow: 0 0 15px rgba(0,150,255,0.6);
}
.settings-space-header .name {
    font-size: 1.4rem;
    font-weight: 700;
    margin-top: 10px;
}
.settings-space-header .cid {
    font-size: 0.9rem;
    color: #a9c4ff;
    margin-top: 4px;
}
.settings-space-header .vip {
    background: linear-gradient(90deg, #00e0ff, #007bff);
    color: #fff;
    display: inline-block;
    margin-top: 10px;
    padding: 4px 12px;
    border-radius: 20px;
    font-weight: 600;
    font-size: 0.85rem;
    box-shadow: 0 0 15px rgba(0,150,255,0.5);
}

/* === MENU LIST === */
.settings-space-content-wrapper {
    background: rgba(255,255,255,0.05);
    margin: 20px 15px;
    border-radius: 16px;
    padding: 15px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.3);
    border: 1px solid rgba(255,255,255,0.05);
}
.settings-space-content-wrapper .flex {
    background: rgba(255,255,255,0.04);
    border-radius: 12px;
    padding: 14px 18px;
    margin-bottom: 10px;
    align-items: center;
    transition: all 0.3s ease;
}
.settings-space-content-wrapper .flex:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 18px rgba(0,150,255,0.3);
}
.settings-space-content-wrapper .label {
    font-weight: 600;
    font-size: 0.95rem;
    display: flex;
    align-items: center;
    gap: 10px;
}
.settings-space-content-wrapper .label i {
    font-size: 18px;
    color: #00e0ff;
}
.settings-space-content-wrapper .value {
    color: #a9c4ff;
    font-size: 0.9rem;
}
.settings-space-content-wrapper svg {
    stroke: #7f9cff;
}

/* === VIP & LOGOUT === */
.settings-space-content-vip {
    background: linear-gradient(135deg, #004aad, #002b5b);
    margin: 20px 15px;
    border-radius: 14px;
    padding: 14px 18px;
    font-weight: 600;
    color: #fff;
    box-shadow: 0 4px 15px rgba(0,150,255,0.4);
    display: flex;
    align-items: center;
    justify-content: space-between;
    cursor: pointer;
}
.settings-space-content-vip:hover {
    transform: scale(1.02);
}
.settings-space-content-logout {
    background: linear-gradient(135deg, #ff3b3b, #d60000);
    color: #fff;
    font-weight: 600;
    text-align: center;
    margin: 20px 15px;
    padding: 12px 0;
    border-radius: 12px;
    box-shadow: 0 0 15px rgba(255,0,0,0.5);
    cursor: pointer;
    transition: all 0.3s ease;
}
.settings-space-content-logout:hover {
    transform: scale(1.05);
    background: linear-gradient(135deg, #ff5555, #d60000);
}
.settings-space-content-tips {
    text-align: center;
    font-size: 12px;
    color: #a9c4ff;
    margin-bottom: 40px;
}

/* === ICON MODERN === */
.icon-modern {
    background: radial-gradient(circle at center, rgba(0,224,255,0.25), transparent 70%);
    border-radius: 50%;
    padding: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: transform 0.3s ease;
}
.icon-modern:hover {
    transform: rotate(8deg) scale(1.1);
}

/* RESPONSIVE */
@media (max-width: 480px) {
    .settings-space-header img {
        width: 85px;
        height: 85px;
    }
}
</style>
</head>
<body>
<div id="__nuxt">
    @include('alert-message')
    <?php
    $vipLevel = \App\Models\Purchase::with('package')->where('user_id', auth()->id())->orderByDesc('id')->first();
    ?>
    <div id="__layout">
        <div>
            <section data-v-1c9a3ff6="" class="settings-space flex flex-col">
                <div data-v-1c9a3ff6="" class="settings-space-header">
                    <div data-v-1c9a3ff6="" class="flex items-center flex-col">
                        <img data-v-1c9a3ff6="" src="{{asset(setting('logo'))}}" alt="">
                        <div data-v-1c9a3ff6="" class="bold name">{{auth()->user()->name}}</div>
                        <div data-v-1c9a3ff6="" class="cid">ID: {{auth()->user()->ref_id}}</div>
                        <div data-v-1c9a3ff6="" class="vip">{{$vipLevel ? $vipLevel->package->name : 'VIP0'}}</div>
                    </div>
                </div>

                <div data-v-1c9a3ff6="" class="settings-space-content flex-1">
                    <div data-v-1c9a3ff6="" class="settings-space-content-wrapper">
                        <div data-v-1c9a3ff6="" class="flex items-center justify-between" onclick="window.location.href='{{url('card')}}'">
                            <div class="label"><span class="icon-modern"><img src="https://api.iconify.design/solar:card-bold.svg?color=%2300e0ff" width="20"></span> Withdraw Account</div>
                            <div class="value">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none">
                                    <path d="M6 12L10 8L6 4" stroke="#8F8A89" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </div>

                        <div class="flex items-center justify-between">
                            <div class="label"><span class="icon-modern"><img src="https://api.iconify.design/solar:user-bold.svg?color=%2300e0ff" width="20"></span> Nickname</div>
                            <div class="value"><span onclick="window.location.href='{{route('user.name')}}'">{{auth()->user()->name}}</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none">
                                    <path d="M6 12L10 8L6 4" stroke="#8F8A89" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </div>

                        <div class="flex items-center justify-between">
                            <div class="label"><span class="icon-modern"><img src="https://api.iconify.design/solar:call-chat-bold.svg?color=%2300e0ff" width="20"></span> Account Number</div>
                            <div class="value"><span>{{auth()->user()->phone}}</span></div>
                        </div>

                        <div class="flex items-center justify-between" onclick="window.location.href='{{route('user.change-password')}}'">
                            <div class="label"><span class="icon-modern"><img src="https://api.iconify.design/solar:lock-password-bold.svg?color=%2300e0ff" width="20"></span> Account Password</div>
                            <div class="value"><span>******</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none">
                                    <path d="M6 12L10 8L6 4" stroke="#8F8A89" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </div>

                        <div class="flex items-center justify-between" onclick="window.location.href='{{route('user.withdraw-password')}}'">
                            <div class="label"><span class="icon-modern"><img src="https://api.iconify.design/solar:shield-keyhole-bold.svg?color=%2300e0ff" width="20"></span> Withdraw Password</div>
                            <div class="value"><span>******</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none">
                                    <path d="M6 12L10 8L6 4" stroke="#8F8A89" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </div>
                    </div>

                    <div class="settings-space-content-vip" onclick="window.location.href='{{route('vip.level')}}'">
                        <div class="label"><img src="https://api.iconify.design/solar:crown-star-bold.svg?color=%23ffd700" width="22"> VIP Level</div>
                        <div class="value"><span>{{$vipLevel ? $vipLevel->package->name : 'VIP-LV'}}</span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none">
                                <path d="M6 12L10 8L6 4" stroke="#fff" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                    </div>

                    <div class="settings-space-content-logout" onclick="window.location.href='{{route('logout')}}'">
                        Logout
                    </div>

                    <div class="settings-space-content-tips">
                        App Version: 1.0
                    </div>
                </div>

                @include('app.layout.menu')
            </section>
        </div>
    </div>
</div>
</body>
</html>
