<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>VIP Investment</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
<style>
:root {
    --primary-color: #16a34a;      /* hijau utama */
    --secondary-color: #052e16;    /* hijau gelap */
    --background-color: #000000;   /* hitam full */
    --text-color: #ECFDF5;
    --light-text-color: #86EFAC;

    --white-color: rgba(5,10,5,0.95);
    --gray-bg: rgba(0,15,8,0.9);

    --success-color: #22c55e;
    --pending-color: #4ade80;
    --failed-color: #ef4444;
}

* {
    margin:0;
    padding:0;
    box-sizing:border-box;
}

html, body {
    background: radial-gradient(circle at top, #0a0f0a 0%, #000000 75%);
    width:100%;
    overflow-x:hidden;
}

body {
    font-family:'Poppins',sans-serif;
    color:var(--text-color);
    -webkit-font-smoothing:antialiased;
}

a { text-decoration:none; color:inherit; }

/* MAIN */
.main-container { 
    width:100%;
    max-width:600px; 
    margin:0 auto;
    background:transparent;
    min-height:100vh;
    position:relative;
}

/* HEADER */
.header { 
    background:linear-gradient(135deg,var(--secondary-color),var(--primary-color));
    padding:15px 20px;
    display:flex;
    align-items:center;
    justify-content:center;
    position:relative;
    box-shadow:0 10px 30px rgba(34,197,94,.45);
}
.header .back-btn {
    position:absolute;
    left:20px;
    font-size:26px;
    color:#86EFAC;
    cursor:pointer;
    font-weight:bold;
}
.header .header-title {
    font-size:1.2rem;
    font-weight:600;
    color:#FFFFFF;
}

/* TABS */
.tabs { 
    display:flex;
    background:var(--gray-bg);
    border-radius:14px;
    padding:5px;
    margin:20px 15px;
    backdrop-filter:blur(14px);
    box-shadow:inset 0 1px 3px rgba(0,0,0,.8);
}
.tab {
    flex:1;
    padding:10px;
    text-align:center;
    font-size:14px;
    font-weight:600;
    cursor:pointer;
    border:none;
    background:transparent;
    color:var(--light-text-color);
    transition:.3s ease;
    border-radius:12px;
}
.tab.active {
    background:linear-gradient(135deg,var(--primary-color),#22c55e);
    color:#FFFFFF;
    box-shadow:0 6px 20px rgba(34,197,94,.5);
}

/* CONTENT */
.content-wrapper {
    padding:10px 15px 120px;
}

.plan-card{
    background:rgba(5,10,5,.95);
    border-radius:20px;
    padding:16px;
    display:flex;
    flex-direction:column; /* Vertikal */
    gap:12px;
    position:relative;
    box-shadow:0 12px 35px rgba(0,0,0,.85);
    border:1px solid rgba(255,255,255,0.05);
}

/* Gambar full di atas */
.plan-image-container{
    width:100%;
    height:180px; /* Bisa diubah sesuai kebutuhan */
    border-radius:16px;
    overflow:hidden;
    background:#020402;
    border:1px solid rgba(255,255,255,0.08);
    box-shadow:inset 0 0 10px rgba(0,0,0,.9);
}
.plan-image{
    width:100%;
    height:100%;
    object-fit:cover;
}

/* Judul tetap di bawah gambar */
.plan-title{
    font-size:1.1rem;
    font-weight:700;
    color:#fff;
    display:flex;
    justify-content:space-between;
    align-items:center;
}

/* Detail semua vertikal */
.plan-details{
    display:grid;
    grid-template-columns:1fr; /* semua vertikal */
    gap:10px;
}

/* Detail item tetap rapi */
.detail-item{
    background:rgba(0,0,0,0.6);
    border:1px solid rgba(255,255,255,0.08);
    border-radius:12px;
    padding:10px;
    display:flex;
    flex-direction:column;
    justify-content:center;
    gap:4px;
    text-align:left;
}
.detail-item span:first-child{
    font-size:.72rem;
    font-weight:500;
    color:#86EFAC;
    opacity:.95;
}
.detail-item .value{
    font-size:.85rem;
    font-weight:800;
    color:#FFFFFF;
}

/* Tombol full bawah */
.action-btn{
    width:100%;
    padding:12px;
    border-radius:14px;
    background:linear-gradient(135deg,#16a34a,#22c55e);
    color:#fff;
    font-size:.95rem;
    font-weight:700;
    border:none;
    cursor:pointer;
    box-shadow:0 6px 20px rgba(34,197,94,.55);
    transition:.3s ease;
}
.action-btn:hover{
    transform:translateY(-2px);
}

</style>
</head>
<body>

<div class="main-container">
    <div class="header">
        <span class="back-btn" onclick="history.back()"></span>
        <h1 class="header-title">URBIN GRIBB</h1>
    </div>

    <div class="tabs">
        <button class="tab active" onclick="switchTab(event,'daily-income')">Daftar invest anda</button>
    </div>

    <div class="content-wrapper">
        @php
            use \App\Models\Package;
            use \App\Models\Purchase;
            use \App\Models\UserLedger;

            $userId = auth()->id();
            $purchasedPackageIds = Purchase::where('user_id',$userId)->where('status','active')->pluck('package_id');
            $packageOne = Package::whereIn('id',$purchasedPackageIds)->where('tab','vip')->get();
            $packagetwo = Package::whereIn('id',$purchasedPackageIds)->where('tab','fixed')->get();
            $packagethree = Package::whereIn('id',$purchasedPackageIds)->where('tab','event')->get();
        @endphp

        <!-- HARiAN -->
        <div id="daily-income" class="plan-list">
            @forelse($packageOne as $element)
                @php
                    $myVip = Purchase::where('user_id',$userId)->where('package_id',$element->id)->first();
                    $last_claim = UserLedger::where(['user_id'=>$userId,'reason'=>'daily_claim_'.$element->id])->latest()->first();
                    $lastPurchaseDate = $last_claim->created_at ?? $myVip->created_at;
                    $diffInHours = $lastPurchaseDate->diffInHours(now());
                    $canClaim = !UserLedger::where(['user_id'=>$userId,'reason'=>'daily_claim_'.$element->id])->whereDate('created_at', today())->exists();
                @endphp
                <div class="plan-card">
                    <div class="plan-title">
                        <span>{{ $element->name }}</span>
                        @if($myVip)
                        <a href="https://chat.whatsapp.com/I9gwgmZIMEEIja29Fncism" target="_blank" class="vip-group">
                            <i class="fab fa-whatsapp"></i> Grup VIP
                        </a>
                        @endif
                    </div>
                    <div class="plan-body">
                        <div class="plan-image-container"><img src="{{ asset($element->photo) }}" alt="{{ $element->name }}" class="plan-image"></div>
                        <div class="plan-details">
                            <div class="detail-item"><span>Harga:</span><span class="value">{{ price($element->price) }}</span></div>
                            <div class="detail-item"><span>Pendapatan Harian:</span><span class="value">{{ price($element->daily_limit) }}</span></div>
                            <div class="detail-item"><span>Total Pendapatan:</span><span class="value">{{ price($element->daily_limit*$element->validity) }}</span></div>
                            <div class="detail-item"><span>Dibeli pada:</span><span class="value">{{ $myVip->created_at->format('d M Y H:i') }}</span></div>
                        </div>
                    </div>

                    @if($diffInHours < 24)
                        <button class="action-btn countdown" id="countdown-{{ $element->id }}">00j 00m 00d</button>
                    @elseif($canClaim)
                        <button class="action-btn" onclick="window.location.href='/my/vip?vip_id={{$element->id}}'">Klaim Sekarang</button>
                    @else
                        <button class="action-btn countdown" disabled>Sudah Diklaim</button>
                    @endif

                    <script>
                        (function(){
                            let lastPurchaseDate = new Date("{{ $lastPurchaseDate }}");
                            let endTime = new Date(lastPurchaseDate.getTime()+24*60*60*1000);
                            const countdownEl = document.getElementById("countdown-{{ $element->id }}");
                            if(!countdownEl) return;
                            function updateCountdown(){
                                let now=new Date().getTime();
                                let distance=endTime-now;
                                if(distance<0){
                                    clearInterval(countdownInterval);
                                    countdownEl.style.display='none';
                                    const claimButton=document.querySelector(`button[onclick*="vip_id={{$element->id}}"]`);
                                    if(claimButton) claimButton.style.display='block';
                                    return;
                                }
                                let h=Math.floor((distance%(1000*60*60*24))/(1000*60*60));
                                let m=Math.floor((distance%(1000*60*60))/(1000*60));
                                let s=Math.floor((distance%(1000*60))/1000);
                                countdownEl.innerText=`${h.toString().padStart(2,'0')}j ${m.toString().padStart(2,'0')}m ${s.toString().padStart(2,'0')}d`;
                            }
                            var countdownInterval=setInterval(updateCountdown,1000);
                            updateCountdown();
                        })();
                    </script>
                </div>
            @empty
                <div class="no-record">Tidak ada rencana harian aktif.</div>
            @endforelse
        </div>

        <!-- MINGGUAN -->
        <div id="welfare-plan" class="plan-list hidden">
            @php $welfarePackages = $packagetwo->merge($packagethree); @endphp
            @forelse($welfarePackages as $element)
                @php
                    $myVip = Purchase::where('user_id',$userId)->where('package_id',$element->id)->first();
                    $endDate = $myVip->created_at->addDays($element->validity);
                @endphp
                <div class="plan-card">
                    <h3 class="plan-title">{{ $element->name }}</h3>
                    <div class="plan-body">
                        <div class="plan-image-container"><img src="{{ asset($element->photo) }}" alt="{{ $element->name }}" class="plan-image"></div>
                        <div class="plan-details">
                            <div class="detail-item"><span>Harga:</span><span class="value">{{ price($element->price) }}</span></div>
                            <div class="detail-item"><span>Siklus:</span><span class="value">{{ $element->validity }} hari</span></div>
                            <div class="detail-item"><span>Total Keuntungan:</span><span class="value">{{ price($element->daily_limit*$element->validity) }}</span></div>
                            <div class="detail-item"><span>Dibeli pada:</span><span class="value">{{ $myVip->created_at->format('d M Y H:i') }}</span></div>
                            <div class="detail-item"><span>Selesai pada:</span><span class="value">{{ $endDate->format('d M Y H:i') }}</span></div>
                        </div>
                    </div>

                    <button class="action-btn countdown" id="countdown-weekly-{{ $element->id }}">Berjalan</button>

                    <script>
                        (function(){
                            let endDate = new Date("{{ $endDate }}");
                            const countdownEl = document.getElementById("countdown-weekly-{{ $element->id }}");
                            if(!countdownEl) return;
                            function updateCountdown(){
                                let now=new Date().getTime();
                                let distance=endDate-now;
                                if(distance<0){
                                    clearInterval(countdownInterval);
                                    countdownEl.innerText='Klaim Sekarang';
                                    countdownEl.disabled=false;
                                    countdownEl.classList.remove('countdown');
                                    countdownEl.onclick=function(){ window.location.href='/my/vip?vip_id={{$element->id}}'; }
                                    return;
                                }
                                let d=Math.floor(distance/(1000*60*60*24));
                                let h=Math.floor((distance%(1000*60*60*24))/(1000*60*60));
                                let m=Math.floor((distance%(1000*60*60))/(1000*60));
                                let s=Math.floor((distance%(1000*60))/1000);
                                countdownEl.innerText=`${d}d ${h.toString().padStart(2,'0')}j ${m.toString().padStart(2,'0')}m ${s.toString().padStart(2,'0')}d`;
                            }
                            var countdownInterval=setInterval(updateCountdown,1000);
                            updateCountdown();
                        })();
                    </script>
                </div>
            @empty
                <div class="no-record">Tidak ada rencana aktif.</div>
            @endforelse
        </div>
    </div>
@include('app.layout.menu')
<script>
function switchTab(evt,tabId){
    document.querySelectorAll('.plan-list').forEach(c=>c.classList.add('hidden'));
    document.querySelectorAll('.tab').forEach(t=>t.classList.remove('active'));
    document.getElementById(tabId).classList.remove('hidden');
    evt.currentTarget.classList.add('active');
}
</script>

</body>
</html>
