<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, viewport-fit=cover">
<title>Mine</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

<style>
:root{
  --maroon-dark:#052e16;
  --maroon-main:#16a34a;
  --maroon-soft:#22c55e;
  --maroon-border:#4ade80;
  --maroon-accent:#86efac;
  --black-main:#000000;
  --black-soft:#0a0f0a;
}

*{box-sizing:border-box;margin:0;padding:0}

body{
  font-family:'Poppins',sans-serif;
  color:#ECFDF5;
  padding-bottom:90px;
  background:radial-gradient(circle at top,#0a0f0a 0%,#000000 70%);
}

/* WRAPPER */
.main-container{
  max-width:520px;
  margin:18px auto;
  padding:0 14px;
}

/* HEADER */
.header{
  background:rgba(5,20,10,.78);
  border:1.5px solid var(--maroon-border);
  backdrop-filter:blur(12px);
  border-radius:14px;
  padding:14px 18px;
  display:flex;
  align-items:center;
  gap:12px;
  margin-bottom:18px;
}

.header-title{
  font-size:18px;
  font-weight:700;
  color:#bbf7d0;
}

/* PROFILE CARD */
.profile-action-card{
  background:linear-gradient(135deg,rgba(5,25,10,.9),rgba(2,10,5,.88));
  border:1.5px solid var(--maroon-border);
  border-radius:18px;
  padding:18px;
  backdrop-filter:blur(14px);
  box-shadow:0 12px 35px rgba(0,0,0,.65);
  margin-bottom:18px;
}

.profile-top{
  display:flex;
  gap:14px;
  align-items:center;
}

.profile-avatar{
  width:64px;
  height:64px;
  border-radius:50%;
  border:2px solid var(--maroon-accent);
  object-fit:cover;
}

.profile-id{
  font-size:13px;
  color:#bbf7d0;
  font-weight:600;
}

.profile-label{
  font-size:13px;
  color:#86efac;
}

.profile-balance{
  font-size:26px;
  font-weight:700;
  color:#FFFFFF;
}

/* DIVIDER */
.horizontal-divider{
  height:1px;
  background:rgba(34,197,94,.4);
  margin:14px 0;
}
.vertical-divider{
  width:1px;
  background:rgba(34,197,94,.4);
}

/* ACTION CARD */
.action-card{
  display:flex;
  height:90px;
}

.checkin-area,
.right-btn{
  flex:1;
  display:flex;
  align-items:center;
  justify-content:center;
  font-weight:600;
  cursor:pointer;
  color:#bbf7d0;
}

.checkin-area{
  background:rgba(5,35,15,.85);
  border-radius:12px 0 0 12px;
}

.right-area{
  flex:1;
  display:flex;
  flex-direction:column;
}

.right-btn{
  background:rgba(10,50,20,.85);
}

/* STATS */
.profile-stats{
  display:flex;
  gap:12px;
  margin-bottom:20px;
}

.stat-box{
  flex:1;
  background:rgba(5,35,15,.85);
  border:1px solid var(--maroon-border);
  border-radius:14px;
  padding:12px;
  text-align:center;
}

.stat-label{
  font-size:12px;
  color:#86efac;
}

.stat-value{
  font-size:14px;
  font-weight:700;
  color:#FFFFFF;
}

/* MENU BUTTONS */
.action-buttons{
  display:flex;
  flex-direction:column;
  gap:14px;
  margin-bottom:20px;
}

.action-btn{
  display:flex;
  align-items:center;
  gap:14px;
  padding:14px 16px;
  border-radius:14px;
  background:rgba(5,20,10,.78);
  border:1.5px solid var(--maroon-border);
  backdrop-filter:blur(12px);
  cursor:pointer;
}

.action-btn img{
  width:38px;
}

.action-btn div{
  font-size:15px;
  font-weight:600;
  color:#bbf7d0;
}

/* LOGOUT */
.menu-item{
  display:flex;
  align-items:center;
  gap:12px;
  padding:14px;
  border-radius:14px;
  background:rgba(10,50,20,.85);
  border:1px solid #22c55e;
  text-decoration:none;
}

.menu-item img{
  width:36px;
}

.menu-text{
  font-size:15px;
  font-weight:700;
  color:#22c55e;
}

</style>
</head>

<body>

<div class="main-container">
<div class="profile-action-card">
  <div class="profile-top">
    <img src="Gemini_Generated_Image_ovzfygovzfygovzf.png" class="profile-avatar">
    <div>
      <div class="profile-id">ID : {{ auth()->user()->phone }}</div>
      <div class="profile-label">Saldo Akun</div>
      <div class="profile-balance">{{ price(auth()->user()->balance) }}</div>
    </div>
  </div>

  <div class="horizontal-divider"></div>

  <div class="action-card">
    <div class="checkin-area" onclick="location.href='/checkin'">Check-in</div>
    <div class="vertical-divider"></div>
    <div class="right-area">
      <div class="right-btn" onclick="openPage('/user/recharge')">Isi Ulang</div>
      <div class="right-btn" onclick="openPage('/withdraw')">Withdraw</div>
    </div>
  </div>
</div>

<div class="profile-stats">
  <div class="stat-box">
    <div class="stat-label">Total Penarikan</div>
    <div class="stat-value">
      {{ price(\App\Models\Withdrawal::where('user_id', auth()->id())->where('status','approved')->sum('amount')) }}
    </div>
  </div>
  <div class="stat-box">
    <div class="stat-label">Total Deposit</div>
    <div class="stat-value">
      {{ price(\App\Models\Deposit::where('user_id', auth()->id())->where('status','approved')->sum('amount')) }}
    </div>
  </div>
</div>

<!-- GRID ACTION BUTTONS DENGAN ICON -->
<div class="action-buttons-grid">
  <div class="action-btn" onclick="location.href='/promo'">
    <svg class="action-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 14l2-2 4 4M7 10l5-5 5 5"/>
    </svg>
    <span>Bonus</span>
  </div>
  <div class="action-btn" onclick="location.href='/history'">
    <svg class="action-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10m-10 4h10m-7 4h4"/>
    </svg>
    <span>History</span>
  </div>
  <div class="action-btn" onclick="location.href='/add/card'">
    <svg class="action-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M3 6h18M3 14h18M3 18h18"/>
    </svg>
    <span>Bank</span>
  </div>
</div>

<a href="/logout" class="menu-item">
  <svg class="action-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a2 2 0 11-4 0v-1m0-8V7a2 2 0 114 0v1"/>
  </svg>
  <span class="menu-text">Keluar</span>
</a>

<style>
.action-buttons-grid {
  display: grid;
  grid-template-columns: repeat(3, 1fr);
  gap: 15px;
  padding: 15px;
}

.action-btn {
  background: linear-gradient(135deg, #064E3B, #16A34A);
  color: #ECFDF5;
  font-weight: 600;
  text-align: center;
  padding: 20px 0;
  border-radius: 16px;
  cursor: pointer;
  box-shadow: 0 4px 12px rgba(22,163,74,0.5);
  transition: 0.3s ease;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
}

.action-btn:hover {
  transform: translateY(-4px) scale(1.05);
  box-shadow: 0 8px 20px rgba(22,163,74,0.7);
}

.action-icon {
  width: 28px;
  height: 28px;
  margin-bottom: 8px;
  stroke: #ECFDF5;
  transition: 0.3s ease;
}

.action-btn:hover .action-icon {
  stroke: #22C55E; /* hijau cerah saat hover */
}

.menu-item {
  display: flex;
  align-items: center;
  justify-content: center;
  margin-top: 20px;
  background: #000000;
  color: #ECFDF5;
  text-decoration: none;
  padding: 15px;
  border-radius: 16px;
  font-weight: 600;
  gap: 10px;
  box-shadow: 0 4px 12px rgba(22,163,74,0.4);
  transition: 0.3s ease;
}

.menu-item:hover {
  background: #064E3B;
  box-shadow: 0 8px 18px rgba(22,163,74,0.6);
}

.menu-item .action-icon {
  width: 24px;
  height: 24px;
  stroke: #ECFDF5;
}
</style>


</div>

@include('app.layout.menu')
</body>
</html>
