<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
    <title>My Bank Card</title>
    <link rel="shortcut icon" type="image/x-icon" href="/IMG_20250918_172903_494.jpg">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

    <style>
        :root {
            --primary-color: #0047ab; /* Main blue from the screenshot */
            --background-color: #f4f6f8;
            --text-color: #333;
            --light-text-color: #6c757d;
            --white-color: #fff;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }

        html, body {
            background-color: var(--background-color);
            overflow-x: hidden;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            color: var(--text-color);
            -webkit-font-smoothing: antialiased;
        }

        a { text-decoration: none; color: inherit; }

        .main-container { 
            max-width: 600px; 
            margin: 0 auto; 
            background-color: var(--background-color); 
            min-height: 100vh; 
            position: relative;
        }

        /* Header */
        .header { 
            background: var(--white-color); 
            padding: 15px 20px; 
            display: flex; 
            align-items: center; 
            justify-content: center; 
            position: relative;
        }
        
        .header .back-btn { 
            position: absolute; 
            left: 20px; 
            font-size: 28px; 
            color: var(--text-color); 
            cursor: pointer; 
            font-weight: bold; 
        }
        
        .header .header-title { 
            font-size: 1.2rem; 
            font-weight: 600; 
        }

        /* Banner Image */
        .banner-image {
            width: 100%;
            display: block;
            height: auto; /* Maintain aspect ratio */
        }
        
        /* Content Wrapper */
        .content-wrapper {
            padding: 15px;
            padding-bottom: 100px;
        }
        
        /* Service Menu */
        .service-menu .menu-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 15px;
            color: var(--text-color);
        }
        .service-menu .menu-list {
            background: var(--white-color);
            border-radius: 16px;
            padding: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
            margin-bottom: 20px;
        }

        /* Credit Card Visual */
        .credit-card-visual {
            background: var(--primary-color);
            color: var(--white-color);
            border-radius: 12px;
            padding: 20px;
            position: relative;
            font-family: 'Courier New', Courier, monospace;
        }
        .credit-card-visual .card-type {
            font-size: 16px;
            font-weight: 600;
        }
        .credit-card-visual .card-number {
            font-size: 22px;
            letter-spacing: 2px;
            margin: 25px 0;
            text-align: center;
        }
        .credit-card-visual .card-holder-name {
            font-size: 14px;
            text-transform: uppercase;
        }
        .credit-card-visual .card-holder-label {
            font-size: 10px;
            opacity: 0.7;
        }
        
        .no-record {
            text-align: center;
            padding: 40px 20px;
            color: var(--light-text-color);
        }

        /* Action Button */
        .action-button {
            display: block;
            width: 100%;
            padding: 15px;
            background: var(--primary-color);
            color: var(--white-color);
            text-align: center;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            box-shadow: 0 4px 15px rgba(0, 71, 171, 0.2);
        }

        /* Bottom Navigation */
        .bottom-nav { 
            position: fixed; 
            bottom: 0; 
            left: 50%;
            transform: translateX(-50%);
            width: 100%; 
            max-width: 600px; 
            background: var(--white-color); 
            display: flex; 
            justify-content: space-around; 
            padding: 10px 0; 
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1); 
            align-items: center;
            z-index: 1000;
        }
        .nav-item { 
            display: flex; 
            flex-direction: column; 
            align-items: center; 
            gap: 5px; 
            cursor: pointer; 
            text-decoration: none; 
            color: var(--light-text-color); 
            flex: 1; 
        }
        .nav-icon { width: 24px; height: 24px; }
        .nav-label { font-size: 12px; }
        .nav-item.active .nav-label { color: var(--primary-color); font-weight: 600; }
    </style>
</head>   
<body>
<div class="main-container">

    <div class="header">
        <span class="back-btn" onclick="history.back()">‹</span>
        <h1 class="header-title">My Bank Card</h1>
    </div>

    <!-- ব্যানার এখানে যুক্ত করুন -->
    <img src="/img/your-banner-image.jpg" alt="Promotional Banner" class="banner-image">
    <!-- অনুগ্রহ করে src="/img/your-banner-image.jpg" এর জায়গায় আপনার সঠিক ব্যানারের লিঙ্ক দিন -->

    <div class="content-wrapper">
        <div class="service-menu">
            <div class="menu-title">Bank Card Information</div>
            <div class="menu-list">
                @if(!auth()->user()->gateway_number || !auth()->user()->gateway_method)
                    <div class="no-record">
                        এখনো কোনো কার্ড নেই।
                    </div>
                @else
                    @php
                        $method = \App\Models\PaymentMethod::where('id', auth()->user()->gateway_method)->first();
                    @endphp
                    @if($method)
                        <div class="credit-card-visual">
                            <div class="card-type">{{ $method->name ?? 'Unknown Method' }}</div>
                            <div class="card-number">{{ auth()->user()->gateway_number }}</div>
                            <div class="card-holder-label">Card Holder</div>
                            <div class="card-holder-name">{{ auth()->user()->holder_name }}</div>
                        </div>
                    @else
                        <div class="no-record">
                            সংযুক্ত কার্ডের তথ্য পাওয়া যায়নি।
                        </div>
                    @endif
                @endif
            </div>

            <a href="{{ route('add.bank.card') }}" class="action-button">
                 @if(!auth()->user()->gateway_number && !auth()->user()->gateway_method)
                   ব্যাঙ্ক কার্ড যোগ করুন
                 @else
                   ব্যাংক কার্ড সম্পাদনা করুন
                 @endif
            </a>
        </div>
    </div>

    <div class="bottom-nav">
        <div class="nav-item" onclick="window.location.href='/'">
            <img class="nav-icon" src="https://api.iconify.design/solar:home-2-bold.svg?color=%23666" alt="Home">
            <div class="nav-label">Home</div>
        </div>
        <div class="nav-item" onclick="window.location.href='/my-team'">
            <img class="nav-icon" src="https://api.iconify.design/solar:users-group-rounded-bold.svg?color=%23666" alt="Team">
            <div class="nav-label">Team</div>
        </div>
        <div class="nav-item" onclick="window.location.href='/invite'">
            <img class="nav-icon" src="https://api.iconify.design/solar:share-bold.svg?color=%23666" alt="Invite">
            <div class="nav-label">Invite</div>
        </div>
        <div class="nav-item" onclick="window.location.href='/download'">
            <img class="nav-icon" src="https://api.iconify.design/solar:download-minimalistic-bold.svg?color=%23666" alt="Download">
            <div class="nav-label">Download</div>
        </div>
        <div class="nav-item active" onclick="window.location.href='/mine'">
            <img class="nav-icon" src="https://api.iconify.design/solar:user-circle-bold.svg?color=%230047ab" alt="My">
            <div class="nav-label">My</div>
        </div>
    </div>

</div>

</body>
</html>