

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
  <title>Blog</title>
  <link rel="stylesheet" href="/public/site/layui/css/layui.css">
  <link rel="stylesheet" href="/public/site/css/common.css">
  <style>
    .index_header {
      background: linear-gradient(136deg, #17A278 0%, #18CA72 100%);
      border-bottom-left-radius: 15%;
      border-bottom-right-radius: 15%;
      height: 150px;
    }

    .blog_contents {
      position: relative;
      background: none;
      margin: 15px;
      margin-bottom: 200px;
    }

    .bold_card {
      background: #FFFFFF;
      padding: 15px;
      margin-bottom: 15px;
      border-radius: 16px;
    }

    .bold_card .card_header {
      display: flex;
      justify-content: space-between;

    }

    .bold_card .card_header .title {
      display: flex;
      justify-content: left;

    }

    .bold_card .card_header .title .info {
      padding-left: 10px;
    }

    .bold_card .card_header .title .nickname {
      font-family: Arial, Arial;
      font-weight: 700;
      font-size: 16px;
      color: #333333;
      line-height: 18px;
    }

    .bold_card .card_header .title .account {
      font-family: Arial, Arial;
      font-weight: 400;
      font-size: 14px;
      color: #818393;
      line-height: 16px;
    }

    .bold_card .card_header .gold_bg {
      width: 40px;
      height: 40px;
      background-image: url("/public/site/img/blog/gold_bg.png");
      background-size: 40px 40px;
      background-repeat: no-repeat;
      line-height: 40px;
      font-family: Arial, Arial;
      font-weight: 700;
      font-size: 12px;
      color: #FCAA00;
      text-align: center;
    }

    .bold_card .contents {
      margin-left: 40px;
    }

    .bold_card .contents .text {
      font-family: Arial, Arial;
      font-weight: 400;
      font-size: 16px;
      color: #666666;
      line-height: 20px;
      margin: 10px 0;
    }

    .blog_img {
      width: 100%;
      min-height: 84px;
    }

    .avatar {
      width: 40px;
      height: 40px;
      border-radius: 50%;
      border: 1px solid #EEEEEE;
    }

    .footer {
      margin-left: 40px;
      display: flex;
      justify-content: space-between;
    }

    .footer img {
      width: 16px;
      height: 16px;
    }

    .date {
      font-family: PingFang SC, PingFang SC;
      font-weight: 400;
      font-size: 14px;
      color: #818393;
      line-height: 14px;
    }

    .icon {
      font-family: PingFang SC, PingFang SC;
      font-weight: 400;
      font-size: 16px;
      color: #FCAA00;
    }

    .layui-layer-msg {
      min-width: 180px;
      border: 1px solid #d3d4d3;
      box-shadow: none
    }
  </style>
</head>
<div class="index_header" style="">
  <div class="index_logo">
    <div style="padding-top: 10px">
      <img src="/public/site/img/common/logo.png" style="height: 42px;">
    </div>
    <a href="/service" class="notice" style="background: #22C87F;border-radius: 12px 12px 12px 12px;border: 1px solid #7DD8A2;width:36px;height:36px;line-height: 36px;text-align: center;margin-top: 10px;">
      <img src="/public/site/img/common/service.png" style="height: 24px;width: 24px;">
    </a>
  </div>
</div>

<div class="blog_contents" id="blog_contents" style="overflow: hidden; position: relative;top: -80px">


</div>

<!--	底部内容-开始	  -->
<div id="blog_post" style="position:fixed;right:0px;bottom:200px;background: none;width: 80px;padding: 10px 0">
  <a href="javascript:" class="rules">
    <img src="/public/site/img/blog/rules.png" style="width: 70px;height: 70px">

  </a>
  <a href="#">
    <img src="/public/site/img/blog/publish.png" style="width: 70px;height: 70px">
  </a>
</div>
<!--	底部内容-结束	  -->

<!--	底部内容-开始	  -->
<div class="footer_menu">

  <div class="content">
    <a href="/" class="item ">
      <img src="/public/site/img/footer/home.png" />
      <p>Home</p>
    </a>
    <a href="/vip" class="item ">
      <img src="/public/site/img/footer/invest.png" />
      <p>Invest</p>
    </a>
    <a href="/blog" class="item active">
      <img src="/public/site/img/footer/mboard_active.png" />
      <p>Blog</p>
    </a>
    <a href="/my-team" class="item ">
      <img src="/public/site/img/footer/notice.png" />
      <p>Team</p>
    </a>


    <a href="/mine" class="item ">
      <img src="/public/site/img/footer/account.png" />
      <p>Account</p>
    </a>
  </div>
</div>
<!--	底部内容-结束	  -->

<!-- body 末尾处引入 layui -->
<script src="/public/site/layui/layui.js"></script>

<script>
  layui.use(function () {
    var $ = layui.jquery;
    var layer = layui.layer;
    var flow = layui.flow;

    $(document).on('click', '.blog_img', function () {
      var image = $(this).attr('src')
      layer.photos({
        photos: {
          "title": "blog image",
          "start": 0,
          "data": [{
            "alt": "",
            "pid": 1,
            "src": image,
          }]
        },
        footer: false // 是否显示底部栏 --- 2.8.16+
      });
    })
    $('.rules').click(function () {
      var content = '<div class="dialog">' +
        '<div class="dialog_contents">' +
        '<p class="explain">Reward Description</p>' +
        '<p class="title" >Share withdrawal screenshots to receive cash rewards</p>' +
        '<p class="text" >Send a screenshot of the latest successful withdrawal to the comment section, and once approved, you will immediately receive a reward of  10-400 </p>' +
        // '<div style="padding: 10px 20px;" id="close"><p class="layui-btn layui-btn-fluid layui-btn-lg" style="background: linear-gradient( 270deg, #0672B5 0%, #1C8ED5 100%);border-radius: 100px 100px 100px 100px;">I Know</p></div>' +
        '</div></div>'

      layer.open({
        type: 1,
        area: ['90%', 'auto'], // 宽高
        title: false, // 不显示标题栏
        closeBtn: true,
        shadeClose: true, // 点击遮罩关闭层
        content: content
      });
    })

    $(document).on('click', '#close', function () {
      layer.closeAll()
    })


  });
</script>
</body>

</html>