<style>
:root{
  --green-main:#16A34A;      /* emerald */
  --green-dark:#064E3B;      /* dark emerald */
  --green-light:#22C55E;     /* light emerald */
  --text-soft:#A7F3D0;
  --text-white:#ECFDF5;
  --glow:rgba(34,197,94,.7);
}

/* ===============================
   BOTTOM NAVBAR
================================ */
.bottom-nav{
  position:fixed;
  bottom:0;
  left:50%;
  transform:translateX(-50%);
  width:100%;
  max-width:600px;
  background:linear-gradient(135deg,var(--green-dark),var(--green-main));
  display:flex;
  justify-content:space-around;
  padding:12px 0 14px;
  border-radius:18px 18px 0 0;
  box-shadow:0 -6px 30px var(--glow);
  z-index:999;
}

/* ===============================
   NAV ITEM
================================ */
.nav-item{
  flex:1;
  text-align:center;
  cursor:pointer;
  position:relative;
}

/* ICON */
.nav-svg{
  width:26px;
  height:26px;
  fill:var(--text-soft);
  transition:.3s ease;
  filter:drop-shadow(0 0 6px rgba(34,197,94,.5));
}

/* LABEL */
.nav-label{
  font-size:11px;
  margin-top:4px;
  color:var(--text-soft);
  font-weight:600;
  transition:.3s ease;
}

/* ===============================
   ACTIVE STATE
================================ */
.nav-item.active .nav-svg{
  fill:var(--text-white);
  filter:drop-shadow(0 0 12px rgba(167,243,208,.9));
  transform:translateY(-4px) scale(1.15);
}

.nav-item.active .nav-label{
  color:var(--text-white);
}

.nav-item.active::after{
  content:'';
  position:absolute;
  bottom:-8px;
  left:50%;
  transform:translateX(-50%);
  width:8px;
  height:8px;
  background:var(--green-light);
  border-radius:50%;
  box-shadow:0 0 14px var(--glow);
}

/* ===============================
   HOVER EFFECT
================================ */
.nav-item:hover .nav-svg{
  fill:#ECFDF5;
  transform:translateY(-2px);
}
</style>


<div class="bottom-nav">

  <div class="nav-item" onclick="location.href='/'">
    <svg class="nav-svg" viewBox="0 0 24 24">
      <path d="M3 10.5L12 3l9 7.5V21a1 1 0 0 1-1 1h-5v-6h-6v6H4a1 1 0 0 1-1-1z"/>
    </svg>
    <div class="nav-label">Home</div>
  </div>

  <div class="nav-item" onclick="location.href='/vip'">
    <svg class="nav-svg" viewBox="0 0 24 24">
      <path d="M21 7l-9-4-9 4v10l9 4 9-4z"/>
    </svg>
    <div class="nav-label">Investasi</div>
  </div>

  <!-- PROFIL DI TENGAH -->
  <div class="nav-item active" onclick="location.href='/mine'">
    <svg class="nav-svg" viewBox="0 0 24 24">
      <path d="M12 12a5 5 0 1 0-5-5 5 5 0 0 0 5 5zm0 2c-4 0-8 2-8 5v1h16v-1c0-3-4-5-8-5z"/>
    </svg>
    <div class="nav-label">Profil</div>
  </div>

  <div class="nav-item" onclick="location.href='/my-team'">
    <svg class="nav-svg" viewBox="0 0 24 24">
      <path d="M16 11a4 4 0 1 0-8 0c0 1.5.8 2.8 2 3.5V17H6a4 4 0 0 0-4 4h20a4 4 0 0 0-4-4h-4v-2.5c1.2-.7 2-2 2-3.5z"/>
    </svg>
    <div class="nav-label">Team</div>
  </div>

  <!-- ABOUT -->
  <div class="nav-item" onclick="location.href='/about-us'">
    <svg class="nav-svg" viewBox="0 0 24 24">
      <path d="M12 2a10 10 0 1 0 10 10A10 10 0 0 0 12 2zm1 15h-2v-6h2zm0-8h-2V7h2z"/>
    </svg>
    <div class="nav-label">About</div>
  </div>

</div>
