<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Register</title>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root{
  --green-1:#16A34A;
  --green-2:#22C55E;
  --green-3:#064E3B;

  --glass:rgba(0,0,0,.55);
  --border:rgba(22,163,74,.45);
  --shadow:rgba(22,197,94,.75);
  --text:#ECFDF5;
}

/* RESET */
*{box-sizing:border-box;margin:0;padding:0}

/* BODY */
body{
  font-family:'Poppins',sans-serif;
  background:
    linear-gradient(rgba(0,0,0,.78), rgba(0,0,0,.92)),
    url("bg.jpg") center/cover no-repeat fixed;
  color:var(--text);
  overflow-x:hidden;
  position:relative;
}

/* KOIN BERJATUHAN */
.coin-container{
  position:fixed;
  inset:0;
  z-index:-1;
  pointer-events:none;
}
.coin{
  position:absolute;
  width:10px;height:10px;
  background:var(--green-2);
  border-radius:50%;
  opacity:.7;
  box-shadow:0 0 10px var(--shadow);
  animation:fall linear infinite;
}
@keyframes fall{
  0%{transform:translateY(-20px) rotate(0deg);opacity:0}
  50%{opacity:1}
  100%{transform:translateY(110vh) rotate(360deg);opacity:0}
}

/* CARD */
.page-wraper{
  max-width:420px;
  min-height:100vh;
  margin:auto;
  margin-top:30px;
  background:var(--glass);
  backdrop-filter:blur(16px);
  border:1px solid var(--border);
  box-shadow:0 25px 70px rgba(0,0,0,.65);
  border-radius:26px;
  overflow:hidden;
}

/* HEADER */
.header{
  text-align:center;
  padding:25px 20px 15px;
  background:linear-gradient(135deg,var(--green-3),var(--green-1));
  border-bottom-left-radius:18px;
  border-bottom-right-radius:18px;
  box-shadow:0 12px 35px rgba(0,0,0,.6);
}
.header-title{
  font-size:22px;
  font-weight:800;
  color:var(--text);
  text-shadow:0 0 20px var(--shadow);
}

/* LOGO BULAT */
.logo-wrapper{
  display:flex;
  justify-content:center;
  margin-top:0px;
}
.logo-circle{
  width:110px;height:110px;
  border-radius:50%;
  overflow:hidden;
  background:#000;
  border:4px solid var(--green-2);
  box-shadow:0 0 35px var(--shadow);
}
.logo-circle img{
  width:100%;
  height:100%;
  object-fit:cover;
}

/* FORM */
form{
  padding:40px 26px 20px;
}
.input-group{
  display:flex;
  align-items:center;
  margin-bottom:18px;
  background:rgba(0,0,0,.45);
  border:1px solid rgba(22,163,74,.45);
  border-radius:16px;
  transition:.3s;
}
.input-group:focus-within{
  box-shadow:0 0 24px var(--shadow);
  transform:scale(1.02);
}
.input-icon{
  width:52px;
  text-align:center;
  color:var(--green-2);
}
.input-field{
  flex:1;
  padding:15px;
  border:none;
  background:none;
  color:#fff;
  font-size:15px;
}
.input-field::placeholder{color:#A7F3D0}
.input-field:focus{outline:none}

/* CAPTCHA */
.captcha-container{
  display:flex;
  align-items:center;
  justify-content:space-between;
  margin-bottom:18px;
}
.captcha-box{
  padding:10px 22px;
  font-size:20px;
  letter-spacing:6px;
  font-weight:800;
  color:var(--green-2);
  background:rgba(0,0,0,.45);
  border-radius:14px;
  box-shadow:inset 0 0 18px var(--shadow);
}
.refresh-btn{
  background:none;
  border:none;
  color:var(--green-2);
  font-size:22px;
  cursor:pointer;
  transition:.3s;
}
.refresh-btn:hover{transform:rotate(180deg)}

/* BUTTON */
.submit-btn{
  width:100%;
  padding:15px;
  border:none;
  border-radius:40px;
  background:linear-gradient(135deg,var(--green-1),var(--green-2),var(--green-3));
  color:#fff;
  font-size:18px;
  font-weight:800;
  cursor:pointer;
  box-shadow:0 0 40px var(--shadow);
  transition:.3s;
}
.submit-btn:hover{
  transform:scale(1.05);
  box-shadow:0 0 60px rgba(22,197,94,.95);
}

/* FOOTER */
.register-text{
  text-align:center;
  padding:18px;
  font-size:14px;
}
.register-text a{
  color:var(--green-2);
  font-weight:700;
  text-decoration:none;
}

.error-message{
  display:none;
  text-align:center;
  color:#ffb4b4;
  font-weight:700;
  margin-bottom:10px;
}
</style>
</head>

<body>

<div class="coin-container">
  <div class="coin" style="left:5%; animation-duration:5s;"></div>
  <div class="coin" style="left:20%; animation-duration:6s;"></div>
  <div class="coin" style="left:35%; animation-duration:4s;"></div>
  <div class="coin" style="left:50%; animation-duration:7s;"></div>
  <div class="coin" style="left:65%; animation-duration:5.5s;"></div>
  <div class="coin" style="left:80%; animation-duration:6.5s;"></div>
  <div class="coin" style="left:90%; animation-duration:5.8s;"></div>
</div>

<div class="page-wraper">

<header class="header">
  <h1 class="header-title">Daftar Akun</h1>
</header>

<div class="logo-wrapper">
  <div class="logo-circle">
    <img src="Gemini_Generated_Image_ovzfygovzfygovzf.png" alt="Logo">
  </div>
</div>

<form id="registerForm" action="{{ route('register') }}" method="POST">
@csrf
  <div class="input-group">
    <i class="fas fa-user input-icon"></i>
    <input type="text" name="name" class="input-field" placeholder="Username" required>
  </div>

  <div class="input-group">
    <i class="fas fa-mobile-alt input-icon"></i>
    <input type="tel" name="phone" class="input-field" placeholder="Nomor Telepon" required>
  </div>

  <div class="input-group">
    <i class="fas fa-lock input-icon"></i>
    <input type="password" name="password" class="input-field" placeholder="Kata Sandi" required>
  </div>

  <div class="input-group">
    <i class="fas fa-lock input-icon"></i>
    <input type="password" name="password_confirmation" class="input-field" placeholder="Konfirmasi Kata Sandi" required>
  </div>

  <div class="input-group">
    <i class="fas fa-ticket input-icon"></i>
    <input type="text" name="ref_id" id="referralCode" class="input-field" placeholder="Kode Referral (Opsional)">
  </div>

  <div class="captcha-container">
    <div id="captchaBox" class="captcha-box"></div>
    <button type="button" class="refresh-btn" onclick="generateCaptcha()">
      <i class="fas fa-sync-alt"></i>
    </button>
  </div>

  <div class="input-group">
    <i class="fas fa-key input-icon"></i>
    <input type="text" id="otpInput" class="input-field" placeholder="Masukkan Kode OTP" required>
  </div>

  <div id="errorMsg" class="error-message">Kode OTP salah!</div>

  <button class="submit-btn">Buat Akun</button>
</form>

<div class="register-text">
  Sudah punya akun? <a href="{{ url('login') }}">Login sekarang</a>
</div>

</div>

<script>
const captchaBox = document.getElementById("captchaBox");
const otpInput = document.getElementById("otpInput");
const errorMsg = document.getElementById("errorMsg");
const referralCode = document.getElementById("referralCode");

function generateCaptcha() {
  const chars = "123456789ABCDEFGHJKLMNPQRSTUVWXYZ";
  let code = "";
  for (let i = 0; i < 6; i++) code += chars[Math.floor(Math.random()*chars.length)];
  captchaBox.textContent = code;
  captchaBox.dataset.code = code;
  otpInput.value = code; // OTP otomatis sama dengan CAPTCHA
}

// otomatis generate captcha saat halaman dimuat
document.addEventListener("DOMContentLoaded",()=>{
  generateCaptcha();

  // referral otomatis jika ada query ?inviteCode=XXX
  const urlParams = new URLSearchParams(window.location.search);
  if(urlParams.get("inviteCode")){
    referralCode.value = urlParams.get("inviteCode");
  }
});

// validasi saat submit
registerForm.addEventListener("submit", e=>{
  if(otpInput.value.trim().toUpperCase()!==captchaBox.dataset.code){
    e.preventDefault();
    errorMsg.style.display="block";
    generateCaptcha();
  }
});
</script>

</body>
</html>
