<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
<title>Login</title>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root {
  --green-1:#16A34A;
  --green-2:#22C55E;
  --green-3:#064E3B;
  --text:#ECFDF5;
  --glass:rgba(10,10,10,.65);
  --border:rgba(22,163,74,.45);
  --shadow:rgba(22,197,94,.65);
}

/* RESET */
*{box-sizing:border-box;margin:0;padding:0}

/* BODY */
body{
  font-family:'Poppins',sans-serif;
  background: linear-gradient(rgba(0,0,0,.78), rgba(0,0,0,.92)), url("bg.jpg") center/cover no-repeat fixed;
  color: var(--text);
  overflow-x:hidden;
  position:relative;
}

/* =======================
   KOIN BERJATUHAN
======================= */
.coin-container{
  position:fixed;
  inset:0;
  z-index:-1;
  pointer-events:none;
}
.coin{
  position:absolute;
  width:10px; height:10px;
  background: var(--green-2);
  border-radius:50%;
  opacity:.7;
  box-shadow:0 0 10px var(--shadow);
  animation:fall linear infinite;
}
@keyframes fall{
  0%{transform:translateY(-20px) rotate(0deg); opacity:0}
  50%{opacity:1}
  100%{transform:translateY(110vh) rotate(360deg); opacity:0}
}

/* PAGE WRAPPER - LEBIH TENGAH */
.page-wrapper{
  max-width:400px;
  min-height:90vh; /* lebih tinggi untuk tengah */
  margin:auto;
  background: var(--glass);
  backdrop-filter: blur(16px);
  border:1px solid var(--border);
  box-shadow:0 25px 70px rgba(0,0,0,.65);
  border-radius:26px;
  overflow:hidden;

  display:flex;
  flex-direction:column;
  justify-content:flex-start;
  padding-top:40px; /* jarak dari atas */
}

/* HEADER */
.header{
  padding:18px 18px 14px;
  text-align:center;
  background: linear-gradient(135deg,var(--green-3),var(--green-1));
  border-bottom-left-radius:18px;
  border-bottom-right-radius:18px;
  box-shadow:0 12px 35px rgba(0,0,0,.6);
}
.header-title{
  font-size:22px;
  font-weight:800;
  color: var(--text);
  text-shadow:0 0 20px var(--shadow);
}

/* LOGO */
.logo-wrapper{
  display:flex;
  justify-content:center;
  margin-top:10px;  /* sedikit jarak dari header */
  margin-bottom:25px; /* lebih jarak ke form */
}
.logo-circle{
  width:110px;
  height:110px;
  border-radius:50%;
  overflow:hidden;
  background:#000;
  border:4px solid var(--green-2);
  box-shadow:0 0 30px var(--shadow);
}
.logo-circle img{
  width:100%;
  height:100%;
  object-fit:cover;
}

/* FORM */
form{
  padding:0 26px 30px;
}
.input-group{
  display:flex;
  align-items:center;
  margin-bottom:16px;
  background: rgba(0,0,0,.45);
  border:1px solid rgba(22,163,74,.45);
  border-radius:14px;
  transition: .3s;
}
.input-group:focus-within{
  box-shadow:0 0 22px var(--shadow);
  transform:scale(1.02);
}
.input-icon{
  width:45px;
  text-align:center;
  color: var(--green-2);
}
.input-field{
  flex:1;
  padding:14px;
  border:none;
  background:none;
  color:#fff;
  font-size:15px;
}
.input-field::placeholder{color:#A7F3D0}
.input-field:focus{outline:none}

.forgot-link{
  display:block;
  text-align:right;
  font-size:13px;
  color: var(--green-2);
  text-decoration:none;
  margin-bottom:18px;
}

/* BUTTON */
.submit-btn{
  width:100%;
  padding:14px;
  border:none;
  border-radius:40px;
  background: linear-gradient(135deg,var(--green-1),var(--green-2),var(--green-3));
  color:#fff;
  font-size:17px;
  font-weight:700;
  cursor:pointer;
  box-shadow:0 0 30px var(--shadow);
  transition:.3s;
}
.submit-btn:hover{
  transform:scale(1.05);
  box-shadow:0 0 50px rgba(22,197,94,.95);
}

/* REGISTER */
.register-text{
  text-align:center;
  padding:18px;
  font-size:14px;
}
.register-text a{
  color: var(--green-2);
  font-weight:700;
  text-decoration:none;
}
</style>
</head>

<body>

<div class="coin-container">
  <div class="coin" style="left:5%; animation-duration:5s;"></div>
  <div class="coin" style="left:18%; animation-duration:6s;"></div>
  <div class="coin" style="left:32%; animation-duration:4.5s;"></div>
  <div class="coin" style="left:46%; animation-duration:7s;"></div>
  <div class="coin" style="left:60%; animation-duration:5.5s;"></div>
  <div class="coin" style="left:74%; animation-duration:6.5s;"></div>
  <div class="coin" style="left:88%; animation-duration:5.8s;"></div>
</div>

<div class="page-wrapper">

  <header class="header">
    <h1 class="header-title">Welcome back Urbin Gribb</h1>
  </header>

  <div class="logo-wrapper">
    <div class="logo-circle">
      <img src="Gemini_Generated_Image_ovzfygovzfygovzf.png" alt="Logo">
    </div>
  </div>

  <form action="{{ url('login') }}" method="POST">
    @csrf
    <div class="input-group">
      <i class="fas fa-mobile-alt input-icon"></i>
      <input type="tel" name="phone" class="input-field" placeholder="Nomor Telepon" required>
    </div>

    <div class="input-group">
      <i class="fas fa-lock input-icon"></i>
      <input type="password" name="password" class="input-field" placeholder="Kata Sandi" required>
    </div>

    <a href="#" class="forgot-link">Lupa kata sandi?</a>

    <button class="submit-btn">Masuk Sekarang</button>
  </form>

  <div class="register-text">
    Belum punya akun? <a href="{{ url('register') }}">Daftar sekarang</a>
  </div>

</div>
</body>
</html>
