<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::create('users', function (Blueprint $table) {
    $table->id();
    $table->string('ref_by')->nullable(); // ID yang mereferensikan user ini
    $table->string('ref_id')->unique();   // kode referral unik
    $table->string('name');
    $table->string('email')->unique();
    $table->timestamp('email_verified_at')->nullable();
    $table->string('password');
    $table->string('type')->nullable();
    $table->decimal('balance', 15, 2)->default(0); // saldo komisi user 💰
    $table->rememberToken();
    $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
