<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Spin;
use Illuminate\Support\Facades\DB;

class SpinController extends Controller
{
    /**
     * CEK JUMLAH SPIN USER
     */
    public function check()
    {
        $spin = Spin::where('user_id', auth()->id())
            ->where('status', 'unused')
            ->count();

        return response()->json([
            'status' => true,
            'spin' => $spin
        ]);
    }

    /**
     * TAMBAH SPIN (DIPANGGIL SAAT BELI PRODUK)
     */
    public function addSpin($purchaseId)
    {
        Spin::create([
            'user_id' => auth()->id(),
            'purchase_id' => $purchaseId,
            'status' => 'unused'
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Spin berhasil ditambahkan'
        ]);
    }

    /**
     * GUNAKAN 1 SPIN (ANTI DOBEL)
     */
    public function useSpin()
    {
        DB::beginTransaction();

        try {
            $spin = Spin::where('user_id', auth()->id())
                ->where('status', 'unused')
                ->lockForUpdate()
                ->first();

            if (!$spin) {
                DB::rollBack();
                return response()->json([
                    'status' => false,
                    'message' => 'Spin habis'
                ]);
            }

            $spin->update([
                'status' => 'used'
            ]);

            DB::commit();

            return response()->json([
                'status' => true,
                'message' => 'Spin digunakan'
            ]);

        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'status' => false,
                'message' => 'Terjadi kesalahan'
            ]);
        }
    }
}
