<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\Package;
use App\Models\Purchase;
use App\Models\User;
use App\Models\UserLedger;
use App\Models\Spin;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class PurchaseController extends Controller
{
public function purchaseConfirmation($id)
{
    session()->put('pop', true);

    $package = Package::find($id);
    $user = Auth::user();

    if (!$package || $package->status !== 'active') {
        return back()->with('error', 'Package inactive');
    }

    // ❌ CEK SUDAH PERNAH BELI ATAU BELUM
    $alreadyBought = Purchase::where('user_id', $user->id)
        ->where('package_id', $package->id)
        ->exists();

    if ($alreadyBought) {
        return back()->with('error', 'Produk ini hanya bisa dibeli satu kali');
    }

    if ($user->balance < $package->price) {
        return back()->with('error', 'Deposit balance too low');
    }

    // Kurangi saldo user
    $user->update([
        'balance'     => $user->balance - $package->price,
        'package_tab' => $package->tab,
    ]);

    // Simpan pembelian
    Purchase::create([
        'user_id'      => $user->id,
        'package_id'   => $package->id,
        'tab'          => $package->tab,
        'amount'       => $package->price,
        'hourly'       => ($package->commission_with_avg_amount / $package->validity) / 24,
        'daily_income' => $package->commission_with_avg_amount / $package->validity,
        'daily_limit'  => $package->daily_limit ?? 1,
        'return_total' => $package->commission_with_avg_amount,
        'date'         => now()->addHours(24),
        'validity'     => now()->addDays($package->validity),
        'status'       => 'active',
    ]);

    // Komisi referral
    $this->giveProductCommission(
        $user->ref_by,
        $package->price,
        $user->id
    );

    return back()->with('success', 'Product purchase successful ✅');
}


    /**
     * Komisi pembelian produk (3 level)
     * Level 1 → 12%, Level 2 → 3%, Level 3 → 1%
     */
    private function giveProductCommission($ref_by, $amount, $from_id)
    {
        if (!$ref_by) {
            Log::warning("No ref_by found for user $from_id, commission skipped.");
            return false;
        }

        $rates = [12, 2, 1];
        $current = $ref_by;

        foreach ($rates as $level => $percent) {
            $upline = User::where('ref_id', $current)->first();
            if (!$upline) break;

            $commission = $amount * $percent / 100;
            $upline->increment('balance', $commission);

            UserLedger::create([
                'user_id' => $upline->id,
                'get_balance_from_user_id' => $from_id,
                'reason' => 'commission',
                'perticulation' => 'Komisi Pembelian Produk Level ' . ($level + 1),
                'amount' => $commission,
                'credit' => $commission,
                'status' => 'approved',
                'step' => 'level_' . ($level + 1),
                'date' => now(),
            ]);

            // Tambahan data spin (jika diperlukan)
            Spin::create([
                'referrer_id' => $upline->id,
                'package_amount' => $commission,
                'reward_amount' => $commission,
                'status' => 'pending',
            ]);

            $current = $upline->ref_by ?? null;
        }

        return true;
    }

    public function vip_confirm($vip_id)
    {
        $vip = Package::find($vip_id);
        return view('app.main.vip_confirm', compact('vip'));
    }
}
