<?php

namespace App\Http\Controllers;

use App\Models\Deposit;
use App\Services\JayaPayment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class TopUpController extends Controller
{
    public function processTopUp(Request $request)
    {
        // VALIDASI INPUT
        $data = $request->validate([
            'amount' => ['required', 'string', 'numeric', 'min:10000', 'max:50000000'],
        ]);

        $user = $request->user();

        // ============================
        // FIX WAJIB UNTUK JAYAPAY
        // ============================

        // Nama: hanya boleh huruf, angka, spasi
        $name = preg_replace('/[^A-Za-z0-9 ]/', '', $user->name ?? 'User');

        // Nomor HP: hanya angka
        $phone = preg_replace('/[^0-9]/', '', $user->phone ?? '0');

        // Format order
        $dateTime = date("YmdHis");
        $orderNum = sprintf('%s-%s', $user->ref_id, $dateTime);

        // PAYLOAD AMAN
        $payload = [
            'dateTime'       => $dateTime,
            'email'          => $user->email,
            'expiryPeriod'   => '1440', // 1 hari
            'name'           => $name,
            'orderNum'       => $orderNum,
            'payMoney'       => $data['amount'],
            'phone'          => $phone,
            'productDetail'  => sprintf('DEPOSIT #%s', $orderNum),
        ];

        // ============================
        // PROSES REQUEST KE JAYAPAY
        // ============================
        $response = JayaPayment::inquiryIDR(config('services.jaya_payment'), $payload);

        if (!$response['status']) {
            Log::error('JAYAPAYMENT_INQUIRY_FAILED', [
                'payload' => $payload,
                'error'   => $response,
            ]);

            return to_route('user.recharge', ['message' => 'INTERNAL_SERVER_ERROR']);
        }

        // SIMPAN INQUIRY
        $deposit = Deposit::inquiry([
            'order_id'        => $orderNum,
            'transaction_id'  => $response['data']['platOrderNum'],
            'amount'          => $data['amount'],
            'user_id'         => $user->id,
        ]);

        if (!$deposit) {
            Log::error('CREATE_INQUIRY_DEPOSIT_FAILED', [
                'order_num' => $orderNum,
            ]);

            return to_route('user.recharge', ['message' => 'INTERNAL_SERVER_ERROR']);
        }

        // SUCCESS → REDIRECT PAYMENT URL
        return redirect($response['data']['url']);
    }
}
