<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Purchase;
use App\Models\User;
use App\Models\UserLedger;
use Carbon\Carbon;

class ProcessDailyIncome extends Command
{
    /**
     * Nama perintah artisan
     */
    protected $signature = 'income:daily';

    /**
     * Deskripsi perintah
     */
    protected $description = 'Memberikan komisi/pendapatan harian otomatis kepada user dari produk yang dibeli setelah 24 jam';

    /**
     * Jalankan perintahnya
     */
    public function handle()
    {
        $now = Carbon::now();

        // Ambil semua pembelian aktif
        $purchases = Purchase::where('status', 'active')
            ->where('date', '<=', $now)
            ->get();

        foreach ($purchases as $purchase) {
            $user = User::find($purchase->user_id);
            if (!$user) continue;

            $income = $purchase->daily_income; // pastikan kolom ini ada di tabel purchases

            // Tambah saldo user
            $user->balance += $income;
            $user->save();

            // Catat ke user_ledger
            UserLedger::create([
                'user_id' => $user->id,
                'reason' => 'daily_income',
                'perticulation' => 'Komisi harian dari pembelian produk',
                'amount' => $income,
                'credit' => $income,
                'status' => 'approved',
                'date' => now(),
            ]);

            // Update tanggal income berikutnya
            $purchase->update([
                'date' => $now->addHours(24),
            ]);

            // Jika masa aktif berakhir, ubah status
            if ($now->greaterThanOrEqualTo($purchase->validity)) {
                $purchase->update(['status' => 'expired']);
            }
        }

        $this->info('✅ Komisi harian berhasil diproses untuk semua user aktif.');
    }
}
